/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.dialogs;

import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.Messages;
import com.ibm.cic.common.ui.utils.WindowUtils;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class StorageLoginDialog
extends TitleAreaDialog {
    private static final String DIALOG_SETTINGS_SECTION_NEW = "StorageLoginDialogNew";
    private static final String DIALOG_SETTINGS_SECTION_OLD = "StorageLoginDialogOld";
    private static final String HELP_ID = String.valueOf(CicCommonUiPlugin.getPluginId()) + ".StorageLoginDialog";
    private static final ImageDescriptor dlgImageDescriptor = ImageDescriptor.createFromFile(StorageLoginDialog.class, (String)"/icons/storage/login_wiz.png");
    private Text password;
    private Text confirm;
    private Button showPassword;
    private Button okButton;
    private Button useMasterPassword;
    private String typedPassword;
    private boolean bUseMasterPassword = true;
    private final boolean confirmPassword;
    private final boolean passwordChange;
    private final String location;
    private Image dlgTitleImage = null;
    private Label labelPassword;
    private Label labelConfirm;

    public StorageLoginDialog(boolean confirmPassword, boolean passwordChange, String location) {
        super(WindowUtils.calculateShell());
        this.confirmPassword = confirmPassword;
        this.passwordChange = passwordChange;
        this.location = location;
    }

    public String getPassword() {
        return this.typedPassword;
    }

    public boolean usesMasterPassword() {
        return this.bUseMasterPassword;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, Messages.buttonLogin, true);
        this.okButton.setEnabled(false);
        this.createButton(parent, 1, Messages.buttonExit, false);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String settingsID;
        IDialogSettings settings = CicCommonUiPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(settingsID = this.confirmPassword ? DIALOG_SETTINGS_SECTION_NEW : DIALOG_SETTINGS_SECTION_OLD);
        if (section == null) {
            section = settings.addNewSection(settingsID);
        }
        return section;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.generalDialogTitle);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, HELP_ID);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.dlgTitleImage = dlgImageDescriptor.createImage();
        this.setTitleImage(this.dlgTitleImage);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeTop = (Composite)super.createDialogArea(parent);
        String titleMsg = this.confirmPassword ? Messages.passwordChangeTitle : (this.passwordChange ? Messages.messageLoginChange : Messages.dialogTitle);
        this.setTitle(titleMsg);
        Composite composite = new Composite(compositeTop, 0);
        if (this.confirmPassword && !this.passwordChange) {
            this.useMasterPassword = new Button(composite, 16416);
            this.useMasterPassword.setSelection(true);
            this.useMasterPassword.setText(Messages.StorageLoginDialog_use_master_password_Label);
            this.useMasterPassword.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    StorageLoginDialog.this.selectionChangedUseMasterPassword(e);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    StorageLoginDialog.this.selectionChangedUseMasterPassword(e);
                }
            });
            GridData gd = new GridData();
            gd.horizontalSpan = 2;
            this.useMasterPassword.setLayoutData((Object)gd);
        }
        this.labelPassword = new Label(composite, 16384);
        this.labelPassword.setText(Messages.labelPassword);
        this.password = new Text(composite, 18432);
        this.password.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                StorageLoginDialog.this.okButton.setEnabled(StorageLoginDialog.this.validatePassword());
            }
        });
        if (this.confirmPassword) {
            this.labelConfirm = new Label(composite, 16384);
            this.labelConfirm.setText(Messages.labelConfirm);
            this.confirm = new Text(composite, 18432);
            this.confirm.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    StorageLoginDialog.this.okButton.setEnabled(StorageLoginDialog.this.validatePassword());
                }
            });
        } else {
            this.confirm = null;
        }
        new Label(composite, 16384);
        this.showPassword = new Button(composite, 131104);
        this.showPassword.setText(Messages.showPassword);
        this.showPassword.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StorageLoginDialog.this.passwordVisibility();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                StorageLoginDialog.this.passwordVisibility();
            }
        });
        this.showPassword.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.showPassword.setSelection(false);
        this.passwordVisibility();
        if (this.location != null) {
            Group locationGroup = new Group(composite, 0);
            locationGroup.setText(Messages.locationGroup);
            GridData groupData = new GridData(4, 4, true, true);
            groupData.horizontalSpan = 2;
            locationGroup.setLayoutData((Object)groupData);
            locationGroup.setLayout((Layout)new GridLayout());
            Label locationLabel = new Label((Composite)locationGroup, 64);
            locationLabel.setText(new Path(this.location).toOSString());
        }
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayoutFactory.swtDefaults().numColumns(2).generateLayout(composite);
        return compositeTop;
    }

    private void selectionChangedUseMasterPassword(SelectionEvent e) {
        this.bUseMasterPassword = this.useMasterPassword.getSelection();
        this.password.setEnabled(this.bUseMasterPassword);
        this.labelPassword.setEnabled(this.bUseMasterPassword);
        this.confirm.setEnabled(this.bUseMasterPassword);
        this.labelConfirm.setEnabled(this.bUseMasterPassword);
        this.showPassword.setEnabled(this.bUseMasterPassword);
        if (!this.bUseMasterPassword) {
            this.okButton.setEnabled(true);
            this.setMessage("", 0);
        } else {
            this.okButton.setEnabled(this.validatePassword());
        }
    }

    protected void passwordVisibility() {
        boolean selected = this.showPassword.getSelection();
        if (selected) {
            this.password.setEchoChar('\u0000');
            if (this.confirm != null) {
                this.confirm.setEchoChar('\u0000');
            }
        } else {
            this.password.setEchoChar('*');
            if (this.confirm != null) {
                this.confirm.setEchoChar('*');
            }
        }
    }

    protected boolean validatePassword() {
        String password2;
        String password1 = this.password.getText();
        if (password1 == null || password1.length() == 0) {
            this.setMessage(Messages.messageEmptyPassword, 3);
            return false;
        }
        if (this.confirm != null && !password1.equals(password2 = this.confirm.getText())) {
            this.setMessage(Messages.messageNoMatch, 2);
            return false;
        }
        this.setMessage("", 0);
        return true;
    }

    protected void okPressed() {
        this.typedPassword = this.password.getText();
        super.okPressed();
    }
}

