/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal;

import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import com.ibm.cic.common.ui.services.UiServices;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class LinkListener
implements Listener {
    private static final Logger logger = Logger.getLogger(LinkListener.class);
    private final String title;
    private final String launchFailureMessage;
    private final Shell shell;

    public LinkListener(Shell shell, String title, String launchFailureMessage) {
        this.shell = shell;
        this.title = title == null ? "" : title;
        this.launchFailureMessage = launchFailureMessage == null ? "" : launchFailureMessage;
    }

    public void handleEvent(Event event) {
        if (!UiServices.getInstance().launchProgram(event.text)) {
            String msg = NLS.bind((String)this.launchFailureMessage, (Object)event.text);
            Status status = new Status(4, CicCommonUiPlugin.getPluginId(), -1, msg, null);
            if (this.shell != null) {
                WrapDetailUIDErrorDialog.openError(this.shell, this.title, null, (IStatus)status);
            } else {
                logger.error(msg);
            }
        }
    }
}

