/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal;

import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.CommonImages;
import com.ibm.cic.common.ui.internal.CommonUILabelProvider;
import com.ibm.cic.common.ui.internal.CommonUIUtils;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormText;

public class FormTextUtil {
    private static final String formStr = "<form>";
    private static final int formStrLen = "<form>".length();
    private static final String COLOR_RED = "red";
    private static final String IMAGE_ERROR = "error";
    private static final String IMAGE_WARNING = "warning";
    private static final String IMAGE_INFO = "info";
    private final CommonUILabelProvider commonLabelProvider = CicCommonUiPlugin.getDefault().getLabelProvider();
    private static final String[] wellKnownFormTextXmlTags = new String[]{"<a ", "</a", "<b>", "<b ", "</b ", "</b>", "<br/>", "<br />", "<img ", "</img>", "</img >", "<li>", "<li ", "</li>", "</li >", "<p>", "<p ", "</p", "</p>", "<span>", "<span ", "</span>", "</span ", "<form>", "</form>"};

    public FormTextUtil() {
        this.commonLabelProvider.connect(this);
    }

    public void dispose() {
        this.commonLabelProvider.disconnect(this);
    }

    public static void connect(FormText formText) {
        final FormTextUtil ext = new FormTextUtil();
        formText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ext.dispose();
            }
        });
        ext.createContentsPrepare(formText);
    }

    public void createContentsPrepare(FormText formText) {
        formText.setColor(COLOR_RED, DisplayKeeper.INSTANCE.getDisplay().getSystemColor(3));
        formText.setImage(IMAGE_ERROR, CicCommonUiPlugin.getDefault().getLabelProvider().get(CommonImages.LOG_ERROR));
        formText.setImage(IMAGE_WARNING, CicCommonUiPlugin.getDefault().getLabelProvider().get(CommonImages.LOG_WARNING));
        formText.setImage(IMAGE_INFO, CicCommonUiPlugin.getDefault().getLabelProvider().get(CommonImages.LOG_INFO));
    }

    public static boolean isFormText(String msg) {
        return msg.startsWith(formStr);
    }

    public static String toFormText(String msg) {
        if (FormTextUtil.isFormText(msg)) {
            return msg;
        }
        return formStr + msg + "</form>";
    }

    public static String prependFormText(String existingFormText, String formText) {
        String s = existingFormText;
        if (!FormTextUtil.isFormText(existingFormText)) {
            s = "<form></form>";
        }
        String p = formText;
        if (!FormTextUtil.isFormText(formText)) {
            p = FormTextUtil.toFormText(formText);
        }
        return String.valueOf(p.substring(0, p.length() - (formStrLen + 1))) + s.substring(formStrLen);
    }

    public static String toFormTextErrorOrWarning(IStatus status) {
        if (status.matches(4)) {
            return FormTextUtil.toFormText(FormTextUtil.toFormTextError(status.getMessage()));
        }
        if (status.matches(2)) {
            return FormTextUtil.toFormText(FormTextUtil.toFormTextWarning(status.getMessage()));
        }
        return null;
    }

    public static String toFormTextError(String msg) {
        return FormTextUtil.toFormTextError(msg, true, null);
    }

    public static String toFormTextError(String msg, boolean escapeSpecialChars, String appendHyperlink) {
        String s = msg;
        if (escapeSpecialChars) {
            s = CommonUIUtils.escapeSpecialChars(msg);
        }
        String h = "";
        if (appendHyperlink != null) {
            h = " " + appendHyperlink;
        }
        return "<p><img href=\"error\"/><span color=\"red\">" + s + "</span>" + h + "</p>";
    }

    public static String toFormTextWarning(String msg) {
        String s = CommonUIUtils.escapeSpecialChars(msg);
        return "<p><img href=\"warning\"/>" + s + "</p>";
    }

    public static String toFormTextInfo(String msg) {
        String s = CommonUIUtils.escapeSpecialChars(msg);
        return "<p><img href=\"info\"/>" + s + "</p>";
    }

    public static String toFormText(OutputFormatter untaggedOutput) {
        String untaggedString = untaggedOutput.toString();
        StringBuffer taggedBuffer = new StringBuffer(untaggedString.length() * 3);
        int tabLength = "    ".length();
        String openTag = "";
        String closeTag = "";
        taggedBuffer.append(formStr);
        int emspaceWidth = 8;
        try {
            emspaceWidth = CommonUIUtils.calculateStringWidth((Control)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "M", 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int indentWidth = emspaceWidth * tabLength;
        String[] stringArray = untaggedString.split(OutputFormatter.NEW_LINE_STR);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            StringBuffer lineBuffer = new StringBuffer(line);
            int indentLevel = 0;
            while (lineBuffer.length() > tabLength && "    ".equals(lineBuffer.substring(0, tabLength))) {
                ++indentLevel;
                lineBuffer.delete(0, tabLength);
            }
            if (indentLevel > 0) {
                openTag = "<li style='text' value='' indent='" + indentLevel * indentWidth + "'>";
                closeTag = "</li>";
            } else {
                openTag = "<p>";
                closeTag = "</p>";
            }
            taggedBuffer.append(openTag).append(FormTextUtil.escapeHTMLString(lineBuffer.toString())).append(closeTag).append(OutputFormatter.NEW_LINE_STR);
            ++n2;
        }
        taggedBuffer.append("</form>");
        return taggedBuffer.toString();
    }

    public static StringBuffer escapeHTMLString(String raw) {
        if (raw == null) {
            return null;
        }
        StringBuffer xml = new StringBuffer();
        boolean bInsideKnownTag = false;
        boolean bInsideAttribute = false;
        int i = 0;
        while (i < raw.length()) {
            block27: {
                char c = raw.charAt(i);
                if ('&' == c) {
                    try {
                        if (raw.substring(i, i + 4).contentEquals("&lt;") || raw.substring(i, i + 4).contentEquals("&gt;") || raw.substring(i, i + 5).contentEquals("&amp;") || raw.substring(i, i + 6).contentEquals("&quot;") || raw.substring(i, i + 6).contentEquals("&apos;")) {
                            xml.append(c);
                            break block27;
                        }
                        xml.append("&amp;");
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        xml.append("&amp;");
                    }
                } else if ('\"' == c) {
                    if (bInsideKnownTag) {
                        bInsideAttribute = !bInsideAttribute;
                        xml.append(c);
                    } else {
                        xml.append("&quot;");
                    }
                } else if ('\'' == c) {
                    if (bInsideKnownTag) {
                        bInsideAttribute = !bInsideAttribute;
                        xml.append(c);
                    } else {
                        xml.append("&apos;");
                    }
                } else if ('\u00a0' == c) {
                    xml.append(" ");
                } else if ('<' == c) {
                    if (bInsideAttribute) {
                        xml.append("&lt;");
                    } else {
                        String s = raw.substring(i);
                        if (FormTextUtil.startWithWellKnownTag(s)) {
                            xml.append(c);
                            bInsideKnownTag = true;
                        } else {
                            xml.append("&lt;");
                        }
                    }
                } else if ('>' == c) {
                    if (bInsideKnownTag && !bInsideAttribute) {
                        xml.append(c);
                        bInsideKnownTag = false;
                    } else {
                        xml.append("&gt;");
                    }
                } else {
                    xml.append(c);
                }
            }
            ++i;
        }
        return xml;
    }

    private static boolean startWithWellKnownTag(String str) {
        String[] stringArray = wellKnownFormTextXmlTags;
        int n = wellKnownFormTextXmlTags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            if (str.startsWith(tag)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

