/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.p2.model.internal;

import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.p2.model.CicP2Model;
import com.ibm.cic.p2.model.IP2Require;
import com.ibm.cic.p2.model.internal.P2Reference;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.osgi.service.resolver.VersionRange;

public class P2Require
extends P2Reference
implements IP2Require {
    private VersionRange fOSGiVer;
    private final IRequiredCapability fReq;

    public P2Require(IRequiredCapability require) {
        super(require.getNamespace(), require.getName());
        this.fReq = require;
    }

    public Object getAdapter(Class adapter) {
        if (IRequiredCapability.class.equals((Object)adapter) || IRequirement.class.equals((Object)adapter)) {
            return this.fReq;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public boolean getGreedy() {
        return this.fReq.isGreedy();
    }

    @Override
    public VersionRange getRange() {
        if (this.fOSGiVer == null && this.fReq.getRange().isOSGiCompatible()) {
            this.fOSGiVer = CicP2Model.toOSGiVersionRange(this.fReq.getRange());
        }
        return this.fOSGiVer;
    }

    @Override
    public boolean isOptional() {
        return this.fReq.getMin() == 0;
    }

    @Override
    public String getFilter() {
        IMatchExpression filter = this.fReq.getFilter();
        if (filter != null) {
            return filter.getParameters()[0].toString();
        }
        return null;
    }

    @Override
    public String getRangeStr() {
        return this.fReq.getRange().toString();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof P2Require) {
            return this.fReq.equals(((P2Require)other).fReq);
        }
        return super.equals(other);
    }

    public String toString() {
        return this.fReq.toString();
    }

    @Override
    public int hashCode() {
        return Util.hashCode((Object)this.fReq);
    }
}

