/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.p2.model;

import com.ibm.cic.p2.model.internal.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ServiceWrapper {
    private ServiceReference fRef;
    private final String fServiceName;
    private final BundleContext fCtx;
    private Object fInst;

    public ServiceWrapper(BundleContext context, String serviceName) {
        this.fCtx = context;
        this.fServiceName = serviceName;
    }

    public synchronized Object acquireInstance() throws CoreException {
        if (this.fInst != null) {
            return this.fInst;
        }
        this.fRef = this.fCtx.getServiceReference(this.fServiceName);
        if (this.fRef == null) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.cic.p2.model", Messages.bind((String)Messages.ServiceWrapper_errAquireService, (Object)this.fServiceName)));
        }
        this.fInst = this.fCtx.getService(this.fRef);
        if (this.fInst == null) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.cic.p2.model", Messages.bind((String)Messages.ServiceWrapper_errSerivceInstance, (Object)this.fServiceName)));
        }
        return this.fInst;
    }

    protected void finalize() throws Throwable {
        if (this.fRef != null) {
            this.fCtx.ungetService(this.fRef);
            System.err.println("Release was not called on a service reference for service " + this.fServiceName);
        }
        super.finalize();
    }

    public synchronized void release() {
        this.fInst = null;
        if (this.fRef != null) {
            this.fCtx.ungetService(this.fRef);
            this.fRef = null;
        }
    }
}

