/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sync.core;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.AbstractVariableSubstitution;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.CacheLocationManager;
import com.ibm.cic.agent.core.CommandRecorder;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.ModifyJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.RollbackJob;
import com.ibm.cic.agent.core.UninstallJob;
import com.ibm.cic.agent.core.UpdateOfferingJob;
import com.ibm.cic.agent.core.api.IAgent;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.common.core.definitions.LanguageCode;
import com.ibm.cic.common.core.model.ExtensionCategory;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import com.ibm.ws.sync.core.SyncLocation;
import com.ibm.ws.sync.core.internal.Messages;
import com.ibm.ws.sync.core.internal.SyncUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class SyncEngine {
    private final Agent agent;
    private static final Logger log = Logger.getLogger(SyncEngine.class);

    public SyncEngine(Agent agent) {
        log.debug("SyncEngine enter");
        this.agent = agent;
        log.debug("SyncEngine exit");
    }

    public IStatus performSynchronization(SyncLocation syncLocation, IProgressMonitor monitor) {
        return this.performSynchronization(syncLocation, monitor, null);
    }

    public IStatus performSynchronization(SyncLocation syncLocation, IProgressMonitor monitor, Properties props) {
        log.debug("SyncEngine.performSynchronization enter");
        log.info(Messages.ImportLogStart);
        boolean skipInstall = this.agent.isSkipInstall();
        String diskSpaceCheck = System.getProperty("cic.override.disk.space");
        String resyncCheckFlag = System.getProperty("cic.disable.resync.check", Boolean.FALSE.toString());
        CommandRecorder commandRecorder = this.agent.getCommandRecorder();
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        status.addAll((IStatus)this.validateSyncLocation(syncLocation));
        if (status.isErrorOrCancel()) {
            monitor.done();
            return status;
        }
        if (!syncLocation.requiresSynchronization()) {
            if (this.isCmdLineMode()) {
                this.outputNoSyncRequired(syncLocation);
            }
            monitor.done();
            log.debug("SyncEngine.PerformSynchronization exit");
            return status;
        }
        Profile[] syncProfile = new Profile[1];
        status.addAll((IStatus)this.getProfile(syncLocation, syncProfile, props));
        if (status.isErrorOrCancel()) {
            monitor.done();
            return status;
        }
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, new int[]{2, 4});
        log.info(Messages.ImportLogJobCreation);
        SyncJobs syncJobs = new SyncJobs(syncProfile[0], syncLocation);
        status.addAll((IStatus)syncJobs.createSyncJobs(spm.next()));
        if (status.isErrorOrCancel()) {
            monitor.done();
            return status;
        }
        AbstractJob[] uninstallJobs = syncJobs.getUninstallSyncJobs();
        AbstractJob[] installJobs = syncJobs.getInstallSyncJobs();
        AbstractJob[] modifyJobs = syncJobs.getModifyJobs();
        ArrayList<AbstractJob> unprepareJobs = new ArrayList<AbstractJob>();
        this.agent.setCommandRecorder(null);
        this.agent.setSkipInstall(true);
        System.setProperty("cic.override.disk.space", Boolean.TRUE.toString());
        System.setProperty("cic.disable.resync.check", Boolean.TRUE.toString());
        double monitorWork = 100.0;
        double numJobs = uninstallJobs.length + installJobs.length + modifyJobs.length;
        SubMonitor jobsMonitor = SubMonitor.convert((IProgressMonitor)spm.next(), (int)((int)monitorWork));
        if (uninstallJobs.length > 0) {
            log.start(log.info(Messages.ImportLogExecuteUninstallJobs));
            double uninstallWork = monitorWork * ((double)uninstallJobs.length / numJobs);
            status.addAll(this.agent.uninstall((AgentJob[])uninstallJobs, (IProgressMonitor)jobsMonitor.newChild((int)uninstallWork)));
            unprepareJobs.addAll(new ArrayList<AbstractJob>(Arrays.asList(uninstallJobs)));
            log.stop();
        }
        if (this.agent.getProfile(syncProfile[0].getProfileId()) == null && installJobs.length > 0) {
            this.agent.addProfile(syncProfile[0]);
        }
        if (installJobs.length > 0 && !status.isErrorOrCancel()) {
            ArrayList<AbstractJob> productJobs = new ArrayList<AbstractJob>(installJobs.length);
            ArrayList<IOffering> productOfferings = new ArrayList<IOffering>(installJobs.length);
            AbstractJob[] abstractJobArray = installJobs;
            int n = installJobs.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractJob job = abstractJobArray[n2];
                IOffering offering = job.getOffering();
                if (offering != null && !this.agent.isAgentOffering((IOfferingOrFix)offering) && !LicenseUtils.isPEKOffering((IOffering)offering)) {
                    productJobs.add(job);
                    productOfferings.add(offering);
                }
                ++n2;
            }
            CacheLocationManager clm = CacheLocationManager.getInstance();
            if (!clm.isSettingCacheLocationByPreference() && clm.isCacheLocationChangeable() && !productJobs.isEmpty()) {
                try {
                    clm.setCacheLocation(clm.calculateDefaultCacheLocation(productJobs));
                }
                catch (AbstractVariableSubstitution.VariableSubstitutionException e) {
                    status.add(e.getStatus());
                }
            }
            if (productJobs.size() > 0 && clm.isCacheLocationChangeable() && !status.isErrorOrCancel()) {
                status.add(AgentUtil.validateCommonDirectoryPermissions((String)clm.getCacheLocation()));
                if (status.isOK()) {
                    status.add((IStatus)AgentUtil.validateCacheLocation((AgentJob[])installJobs, (String)clm.getCacheLocation(), (IOffering[])productOfferings.toArray(new IOffering[productOfferings.size()])));
                }
            }
            if (!status.isErrorOrCancel()) {
                log.start(log.info(Messages.ImportLogExecuteInstallJobs));
                double installWork = monitorWork * ((double)installJobs.length / numJobs);
                status.addAll(this.agent.install((AgentJob[])installJobs, null, null, (IProgressMonitor)jobsMonitor.newChild((int)installWork)));
                this.setOfferingSyncData(syncProfile[0], installJobs);
                unprepareJobs.addAll(new ArrayList<AbstractJob>(Arrays.asList(installJobs)));
                log.stop();
            }
        }
        this.agent.setSkipInstall(skipInstall);
        if (diskSpaceCheck != null && diskSpaceCheck.length() > 0) {
            System.setProperty("cic.override.disk.space", diskSpaceCheck);
        } else {
            System.getProperties().remove("cic.override.disk.space");
        }
        if (modifyJobs.length > 0 && !status.isErrorOrCancel()) {
            log.start(log.info(Messages.ImportLogExecuteModifyJobs));
            double modifyWork = monitorWork * ((double)modifyJobs.length / numJobs);
            status.addAll(this.agent.install((AgentJob[])modifyJobs, null, null, (IProgressMonitor)jobsMonitor.newChild((int)modifyWork)));
            unprepareJobs.addAll(new ArrayList<AbstractJob>(Arrays.asList(modifyJobs)));
            log.stop();
        }
        System.setProperty("cic.disable.resync.check", resyncCheckFlag);
        this.agent.setCommandRecorder(commandRecorder);
        if (uninstallJobs.length > 0 || installJobs.length > 0) {
            this.agent.recordImport("WAS", syncProfile[0], null);
        }
        unprepareJobs.trimToSize();
        if (!unprepareJobs.isEmpty()) {
            this.agent.unprepare((AgentJob[])unprepareJobs.toArray(new AbstractJob[unprepareJobs.size()]), (IProgressMonitor)new NullProgressMonitor());
        }
        if (this.agent.canRemoveProfile(syncProfile[0]) && !status.isErrorOrCancel()) {
            log.info(NLS.bind((String)Messages.ImportLogRemoveProfile, (Object)syncProfile[0].getProfileId()));
            this.agent.removeProfile(syncProfile[0]);
        }
        if (this.isCmdLineMode() && !status.isErrorOrCancel()) {
            this.outputCompletedJobs(syncLocation, installJobs, modifyJobs);
        }
        monitor.done();
        log.info(Messages.ImportLogFinished);
        log.debug("SyncEngine.performSynchronization exit");
        return status;
    }

    protected CicMultiStatus validateSyncLocation(SyncLocation syncLocation) {
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        if (syncLocation == null) {
            status.add((IStatus)Statuses.ERROR.get(Messages.InitializationError, new Object[0]));
        } else {
            String[] noRepositoryOfferings;
            status.add(syncLocation.verifyImportProfile());
            String[] stringArray = noRepositoryOfferings = syncLocation.getAllOfferingsWithoutARepository();
            int n = noRepositoryOfferings.length;
            int n2 = 0;
            while (n2 < n) {
                String noRepositoryOffering = stringArray[n2];
                status.add((IStatus)Statuses.ERROR.get(Messages.NoRepositoryFound, new Object[]{noRepositoryOffering}));
                ++n2;
            }
        }
        return status;
    }

    private void setOfferingSyncData(Profile profile, AbstractJob[] selectedJobs) {
        log.debug("SyncEngine.setOfferingSyncData enter");
        AbstractJob[] abstractJobArray = selectedJobs;
        int n = selectedJobs.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractJob selectedJob = abstractJobArray[n2];
            IOffering offering = selectedJob.getOffering();
            if (offering != null) {
                String offeringId = offering.getIdentity().getId();
                profile.setOfferingUserData("user.cic.imported", "WAS", offeringId);
            }
            ++n2;
        }
        profile.saveUserData((IProgressMonitor)new NullProgressMonitor());
        log.debug("SyncEngine.setOfferingSyncData exit");
    }

    private IStatus createNewProfile(IOffering offering, String installLocation, Profile[] newProfile) {
        log.debug("SyncEngine.createNewProfile enter");
        newProfile[0] = Profile.makeNewImportProfileForOffering((IOffering)offering);
        IStatus locationStatus = newProfile[0].setInstallLocation(installLocation);
        if (!locationStatus.isOK()) {
            newProfile[0] = null;
            log.error(locationStatus.getMessage());
            return locationStatus;
        }
        newProfile[0].setData("cic.selector.nl", LanguageCode.ENGLISH.getId());
        log.debug("SyncEngine.createNewProfile exit");
        return locationStatus;
    }

    private CicMultiStatus getProfile(SyncLocation syncLocation, Profile[] profile, Properties props) {
        log.debug("SyncEngine.getProfile enter");
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        IProfile syncProfile = syncLocation.getProfile();
        if (syncProfile != null) {
            profile[0] = (Profile)syncProfile;
            if (props != null) {
                this.addPropertiesToProfile(profile, props, status);
            }
            return status;
        }
        IOffering baseOffering = syncLocation.getBaseOffering();
        if (baseOffering == null) {
            String[] offeringDescriptions;
            String[] stringArray = offeringDescriptions = syncLocation.getAllOfferingsWithoutARepository();
            int n = offeringDescriptions.length;
            int n2 = 0;
            while (n2 < n) {
                String offeringDescription = stringArray[n2];
                status.add((IStatus)Statuses.ERROR.get(Messages.NoRepositoryFound, new Object[]{offeringDescription}));
                ++n2;
            }
            return status;
        }
        status.add(this.createNewProfile(baseOffering, syncLocation.getLocation(), profile));
        if (props != null) {
            this.addPropertiesToProfile(profile, props, status);
        }
        log.debug("SyncEngine.getProfile exit");
        return status;
    }

    private void addPropertiesToProfile(Profile[] profile, Properties props, CicMultiStatus status) {
        if (profile[0] != null) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                IStatus dataStatus = profile[0].setData((String)entry.getKey(), (String)entry.getValue());
                if (dataStatus.isOK()) continue;
                status.add(dataStatus);
                break;
            }
        }
    }

    private boolean isCmdLineMode() {
        return CmdLine.CL.isSilentMode() && !CmdLine.CL.isConsoleMode();
    }

    private void outputNoSyncRequired(SyncLocation syncLocation) {
        OutputFormatter output = this.agent.getStdoutBuffer();
        output.appendNTnl(NLS.bind((String)Messages.CmdImportSyncNotRequired, (Object)syncLocation.getLocation()));
    }

    private void outputCompletedJobs(SyncLocation syncLocation, AbstractJob[] installJobs, AbstractJob[] modifyJobs) {
        AbstractJob job;
        OutputFormatter output = this.agent.getStdoutBuffer();
        HashSet<IOfferingOrFix> importedSet = new HashSet<IOfferingOrFix>();
        AbstractJob[] abstractJobArray = installJobs;
        int n = installJobs.length;
        int n2 = 0;
        while (n2 < n) {
            job = abstractJobArray[n2];
            importedSet.add(job.getOfferingOrFix());
            ++n2;
        }
        abstractJobArray = modifyJobs;
        n = modifyJobs.length;
        n2 = 0;
        while (n2 < n) {
            job = abstractJobArray[n2];
            importedSet.add(job.getOfferingOrFix());
            ++n2;
        }
        for (IOfferingOrFix offeringOrFix : importedSet) {
            String packageIdAndVersion = OfferingUtil.getPackageIdVersion((IOfferingOrFix)offeringOrFix);
            output.appendNTnl(NLS.bind((String)Messages.CmdImportedOfferingOrFix, (Object)packageIdAndVersion, (Object)syncLocation.getLocation()));
        }
    }

    protected AbstractJob createInstallJob(Profile profile, IOfferingOrFix offering, IFeature[] features) {
        log.debug("SyncEngine.createInstallJob enter");
        InstallJob installJob = new InstallJob(profile, offering, features);
        installJob.setAcceptLicense(true);
        log.debug("SyncEngine.createInstallJob exit");
        return installJob;
    }

    protected AbstractJob createUninstallJob(Profile profile, IOfferingOrFix offering) {
        log.debug("SyncEngine.createUninstallJob enter");
        UninstallJob uninstallJob = new UninstallJob(profile, offering);
        if (offering instanceof IOffering) {
            Set features = this.agent.getInstalledFeatures(profile, (IOffering)offering);
            Iterator it = features.iterator();
            while (it.hasNext()) {
                uninstallJob.addFeature((IFeature)it.next());
            }
        }
        log.debug("SyncEngine.createUninstallJob exit");
        return uninstallJob;
    }

    protected AbstractJob createRollbackJob(Profile profile, IOfferingOrFix rollbackTo, IOffering rollbackFrom) {
        log.debug("SyncEngine.createRollbackJob enter");
        RollbackJob rollbackJob = new RollbackJob(profile, rollbackTo, rollbackFrom);
        log.debug("SyncEngine.createRollbackJob exit");
        return rollbackJob;
    }

    protected AbstractJob createModifyJob(Profile profile, IOfferingOrFix offering, IFeature[] features) {
        log.debug("SyncEngine.createModifyJob enter");
        ModifyJob modifyJob = null;
        modifyJob = features == null || features.length < 1 ? new ModifyJob(profile, offering) : new ModifyJob(profile, offering, Arrays.asList(features), AgentJob.AgentJobType.MODIFY_JOB);
        log.debug("SyncEngine.createModifyJob exit");
        return modifyJob;
    }

    protected AbstractJob createUpdateJob(Profile profile, IOfferingOrFix offeringOrFix, IFeature[] features) {
        log.debug("SyncEngine.createUpdateJob enter");
        InstallJob updateJob = null;
        if (offeringOrFix instanceof IOffering) {
            updateJob = new UpdateOfferingJob(profile, (IOffering)offeringOrFix);
            IFeature[] iFeatureArray = features;
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                IFeature feature = iFeatureArray[n2];
                updateJob.addFeature(feature);
                ++n2;
            }
            updateJob.setAcceptLicense(true);
        } else {
            updateJob = new InstallJob(profile, offeringOrFix);
        }
        log.debug("SyncEngine.createUpdateJob exit");
        return updateJob;
    }

    protected void determineFeaturesToAddRemove(Profile profile, IOffering offering, IFeature[] installedFeatures, List featuresToAdd, List featuresToRemove) {
        log.debug("SyncEngine.determineFeaturesToAddRemove enter");
        if (installedFeatures != null) {
            ModifyJob modifyJob = (ModifyJob)this.createModifyJob(profile, (IOfferingOrFix)offering, installedFeatures);
            modifyJob.determineFeaturesToAddRemove((IAgent)this.agent, featuresToAdd, featuresToRemove);
        }
        log.debug("SyncEngine.determineFeaturesToAddRemove exit");
    }

    public IAgent getAgent() {
        return this.agent;
    }

    private class SyncJobs {
        private final Profile profile;
        private final SyncLocation syncLocation;
        private final ArrayList uninstallSyncJobs;
        private final ArrayList installSyncJobs;
        private final ArrayList modifyJobs;

        public SyncJobs(Profile profile, SyncLocation syncLocation) {
            log.debug("SyncEngine.SyncJobs enter");
            this.profile = profile;
            this.syncLocation = syncLocation;
            this.installSyncJobs = new ArrayList();
            this.uninstallSyncJobs = new ArrayList();
            this.modifyJobs = new ArrayList();
            log.debug("SyncEngine.SyncJobs exit");
        }

        public CicMultiStatus createSyncJobs(IProgressMonitor monitor) {
            log.debug("SyncEngine.SyncJobs.createSynJobs enter");
            CicMultiStatus createJobStatus = Statuses.ST.createMultiStatus();
            int numOfferingAndFixesToUninstall = this.syncLocation.getOfferingsAndFixesToUninstall().length + 1;
            int numOfferingToInstall = this.syncLocation.getOfferingsToInstall().length + 1;
            int numIFixToInstall = this.syncLocation.getIFixesToInstall().length + 1;
            SplitProgressMonitor spm = new SplitProgressMonitor(monitor, new int[]{numOfferingAndFixesToUninstall, numOfferingToInstall, numIFixToInstall});
            createJobStatus.add(this.createSyncUninstallJobs(spm.next()));
            createJobStatus.addAll((IStatus)this.createSyncInstallJobs(spm.next()));
            this.uninstallSyncJobs.trimToSize();
            this.installSyncJobs.trimToSize();
            this.modifyJobs.trimToSize();
            log.debug("SyncEngine.SyncJobs.createSynJobs exit");
            return createJobStatus;
        }

        private IStatus createSyncUninstallJobs(IProgressMonitor monitor) {
            log.debug("SyncEngine.SyncJobs.createSyncUninstallJobs enter");
            IOfferingOrFix[] offeringsAndFixesToUninstall = this.syncLocation.getOfferingsAndFixesToUninstall();
            if (offeringsAndFixesToUninstall != null && offeringsAndFixesToUninstall.length > 0) {
                monitor.beginTask(Messages.ImportingProgressBarText, offeringsAndFixesToUninstall.length);
                IOfferingOrFix[] iOfferingOrFixArray = offeringsAndFixesToUninstall;
                int n = offeringsAndFixesToUninstall.length;
                int n2 = 0;
                while (n2 < n) {
                    IOfferingOrFix element = iOfferingOrFixArray[n2];
                    this.uninstallSyncJobs.add(SyncEngine.this.createUninstallJob(this.profile, element));
                    monitor.worked(1);
                    ++n2;
                }
            } else {
                monitor.beginTask(Messages.ImportingProgressBarText, 1);
            }
            monitor.done();
            log.debug("SyncEngine.SyncJobs.createSyncUninstallJobs exit");
            return Status.OK_STATUS;
        }

        private CicMultiStatus createSyncInstallJobs(IProgressMonitor monitor) {
            Comparable element;
            log.debug("SyncEngine.SyncJobs.createSyncInstallJobs enter");
            SyncLocation.InstalledOffering[] offeringsToInstall = this.syncLocation.getOfferingsToInstall();
            SyncLocation.InstalledFix[] ifixesToInstall = this.syncLocation.getIFixesToInstall();
            CicMultiStatus status = Statuses.ST.createMultiStatus();
            boolean baseOfferingFound = this.syncLocation.isBaseOfferingInSync();
            SubMonitor installMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)((offeringsToInstall.length + 1 + ifixesToInstall.length + 1) * 2));
            Comparable[] comparableArray = offeringsToInstall;
            int n = offeringsToInstall.length;
            int n2 = 0;
            while (n2 < n) {
                block21: {
                    block22: {
                        block20: {
                            element = comparableArray[n2];
                            IOffering repOffering = ((SyncLocation.InstalledOffering)element).getRepositoryOffering();
                            if (repOffering == null) break block20;
                            baseOfferingFound = baseOfferingFound || ((SyncLocation.InstalledOffering)element).isBase();
                            status.addAll(SyncEngine.this.agent.prepare((IOfferingOrFix)repOffering, ExtensionCategory.ALL, (IProgressMonitor)installMonitor.newChild(1)));
                            status.addAll((IStatus)this.syncLocation.productsVersionMatchCheck((SyncLocation.InstalledOffering)element));
                            if (StatusUtil.isErrorOrCancel((IStatus)status)) break block21;
                            IFeature[] installedFeatures = ((SyncLocation.InstalledOffering)element).getInstalledFeatures();
                            IFeature[] importFeatures = ((SyncLocation.InstalledOffering)element).getImportFeatures();
                            IFeature[] installedImportFeatures = ((SyncLocation.InstalledOffering)element).getInstalledImportFeatures();
                            IOffering invOffering = ((SyncLocation.InstalledOffering)element).getInventoryOffering();
                            if (invOffering != null) {
                                if (repOffering.compareVersion((IContent)invOffering) < 0) {
                                    IOffering rollbackOffering = this.determineRollbackOffering((SyncLocation.InstalledOffering)element, invOffering);
                                    if (rollbackOffering != null) {
                                        this.installSyncJobs.add(SyncEngine.this.createRollbackJob(this.profile, (IOfferingOrFix)invOffering, rollbackOffering));
                                    }
                                    invOffering = rollbackOffering;
                                }
                                if (repOffering.compareVersion((IContent)invOffering) == 0) {
                                    if (importFeatures.length > 0 && "WAS".equals(this.profile.getOfferingUserData("user.cic.imported", invOffering.getIdentity().getId()))) {
                                        if (installedImportFeatures.length != importFeatures.length) {
                                            ArrayList<IFeature> importFeaturesToAdd = new ArrayList<IFeature>(Arrays.asList(importFeatures));
                                            importFeaturesToAdd.removeAll(Arrays.asList(installedImportFeatures));
                                            this.modifyJobs.add(SyncEngine.this.createModifyJob(this.profile, (IOfferingOrFix)repOffering, importFeaturesToAdd.toArray(new IFeature[importFeaturesToAdd.size()])));
                                        } else {
                                            installedFeatures = SyncUtil.mergeFeatureLists(installedFeatures, installedImportFeatures);
                                        }
                                    }
                                    ArrayList featuresToAdd = new ArrayList();
                                    ArrayList featuresToRemove = new ArrayList();
                                    SyncEngine.this.determineFeaturesToAddRemove(this.profile, invOffering, installedFeatures, featuresToAdd, featuresToRemove);
                                    if (!featuresToRemove.isEmpty()) {
                                        this.uninstallSyncJobs.add(SyncEngine.this.createModifyJob(this.profile, (IOfferingOrFix)repOffering, featuresToRemove.toArray(new IFeature[featuresToRemove.size()])));
                                    }
                                    if (!featuresToAdd.isEmpty()) {
                                        this.installSyncJobs.add(SyncEngine.this.createModifyJob(this.profile, (IOfferingOrFix)repOffering, featuresToAdd.toArray(new IFeature[featuresToAdd.size()])));
                                    }
                                } else {
                                    this.installSyncJobs.add(SyncEngine.this.createUpdateJob(this.profile, (IOfferingOrFix)repOffering, installedFeatures));
                                    if (importFeatures.length > 0) {
                                        this.modifyJobs.add(SyncEngine.this.createModifyJob(this.profile, (IOfferingOrFix)repOffering, importFeatures));
                                    }
                                }
                            } else {
                                this.installSyncJobs.add(SyncEngine.this.createInstallJob(this.profile, (IOfferingOrFix)repOffering, installedFeatures));
                                if (importFeatures.length > 0) {
                                    this.modifyJobs.add(SyncEngine.this.createModifyJob(this.profile, (IOfferingOrFix)repOffering, importFeatures));
                                }
                            }
                            break block22;
                        }
                        String name = ((SyncLocation.InstalledOffering)element).getOfferingNameAndVersion();
                        if (name == null || "".equals(name)) {
                            name = ((SyncLocation.InstalledOffering)element).getProductName();
                        }
                        status.add((IStatus)Statuses.ERROR.get(Messages.NoRepositoryFound, new Object[]{name}));
                        installMonitor.worked(1);
                    }
                    installMonitor.worked(1);
                }
                ++n2;
            }
            comparableArray = ifixesToInstall;
            n = ifixesToInstall.length;
            n2 = 0;
            while (n2 < n) {
                element = comparableArray[n2];
                IFix repIFix = ((SyncLocation.InstalledFix)element).getRepositoryFix();
                if (repIFix != null) {
                    status.addAll(SyncEngine.this.agent.prepare((IOfferingOrFix)repIFix, ExtensionCategory.ALL, (IProgressMonitor)installMonitor.newChild(1)));
                    if (!StatusUtil.isErrorOrCancel((IStatus)status)) {
                        this.installSyncJobs.add(SyncEngine.this.createInstallJob(this.profile, (IOfferingOrFix)repIFix, new IFeature[0]));
                    }
                } else {
                    status.add((IStatus)Statuses.ERROR.get(Messages.NoRepositoryFound, new Object[]{((SyncLocation.InstalledFix)element).getName()}));
                    installMonitor.worked(1);
                }
                installMonitor.worked(1);
                ++n2;
            }
            installMonitor.done();
            if (!baseOfferingFound && status.getSeverity() != 4) {
                status.add((IStatus)Statuses.ERROR.get(Messages.InitializationError, new Object[0]));
            }
            log.debug("SyncEngine.SyncJobs.createSyncInstallJobs exit");
            return status;
        }

        private IOffering determineRollbackOffering(SyncLocation.InstalledOffering instOffering, IOffering offering) {
            log.debug("SyncEngine.SyncJobs.determineRollbackOffering enter");
            List<String> installedVersions = Arrays.asList(instOffering.getInstalledVersions());
            IOffering[] previouslyInstalledOfferings = SyncEngine.this.agent.getInstalledOfferings(this.profile, offering.getIdentity());
            Arrays.sort(previouslyInstalledOfferings, new SyncLocation.OfferingOrFixComparator());
            IOffering rollbackOffering = null;
            boolean finished = Boolean.FALSE;
            int i = 0;
            while (i < previouslyInstalledOfferings.length && !finished) {
                String previousVersion = previouslyInstalledOfferings[i].getVersion().toString();
                if (installedVersions.contains(previousVersion = SyncUtil.getVersionWithoutQualifier(previousVersion))) {
                    rollbackOffering = previouslyInstalledOfferings[i];
                } else {
                    finished = Boolean.TRUE;
                }
                ++i;
            }
            log.debug("SyncEngine.SyncJobs.determineRollbackOffering exit");
            return rollbackOffering;
        }

        public AbstractJob[] getUninstallSyncJobs() {
            return this.uninstallSyncJobs.toArray(new AbstractJob[this.uninstallSyncJobs.size()]);
        }

        public AbstractJob[] getInstallSyncJobs() {
            return this.installSyncJobs.toArray(new AbstractJob[this.installSyncJobs.size()]);
        }

        public AbstractJob[] getModifyJobs() {
            return this.modifyJobs.toArray(new AbstractJob[this.modifyJobs.size()]);
        }
    }
}

