/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sync.core;

import com.ibm.cic.common.logging.Logger;
import com.ibm.ws.pak.core.utils.IPakUtils;
import com.ibm.ws.pak.core.utils.PakUtils;
import com.ibm.ws.resync.internal.Messages;
import com.ibm.ws.sync.core.SyncConstants;
import com.ibm.ws.sync.core.SyncLocation;
import com.ibm.ws.sync.core.api.IInstalledProduct;
import com.ibm.ws.sync.core.internal.SyncUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class InstalledProduct
implements Comparable,
IInstalledProduct {
    private String installLocation = null;
    private String productId = null;
    private boolean isTrial = false;
    private String[] installedVersions = null;
    private String[] installedPaks = null;
    private String[] installedIfixes = null;
    private String productName = null;
    private boolean initialized = Boolean.FALSE;
    private static final Logger log = Logger.getLogger(SyncLocation.class);

    public InstalledProduct(String installLocation, String productId) {
        log.debug("InstalledProduct enter");
        this.productId = productId;
        this.installLocation = installLocation;
        log.debug("InstalledProduct exit");
    }

    @Override
    public IStatus init() {
        log.debug("InstalledProduct.init enter");
        if (this.initialized) {
            log.debug("InstalledProduct.init exit");
            return Status.OK_STATUS;
        }
        PakUtils pakUtils = new PakUtils();
        this.isTrial = this.isTrialProduct((IPakUtils)pakUtils);
        this.installedVersions = this.getAllVersionsInstalled((IPakUtils)pakUtils);
        this.installedPaks = this.getAllInstalledPaks((IPakUtils)pakUtils);
        this.productName = this.lookupProductName((IPakUtils)pakUtils);
        this.installedIfixes = this.getInstalledIfixMaintenanceName((IPakUtils)pakUtils);
        if (this.isTrial) {
            this.productId = String.valueOf(this.productId) + "TRIAL";
        }
        this.initialized = Boolean.TRUE;
        log.debug("InstalledProduct.init exit");
        return Status.OK_STATUS;
    }

    @Override
    public File getPropertiesFile() {
        return SyncUtil.getIMPropertiesFile(this.installLocation, this.productId);
    }

    protected Properties loadPropertiesFile() throws FileNotFoundException, IOException {
        File propertiesFile = this.getPropertiesFile();
        Properties imProductProperties = new Properties();
        if (propertiesFile.canRead()) {
            try (FileInputStream fis = new FileInputStream(propertiesFile);){
                imProductProperties.load(fis);
            }
        }
        return imProductProperties;
    }

    @Override
    public String getOfferingIdFromIMPropertyFile() {
        String offeringId = "";
        try {
            Properties imProductProperties = this.loadPropertiesFile();
            offeringId = imProductProperties.getProperty("offeringid");
        }
        catch (FileNotFoundException fnfe) {
            log.debug(fnfe.getMessage());
        }
        catch (IOException ioe) {
            log.debug(ioe.getMessage());
        }
        return offeringId;
    }

    @Override
    public String generateOfferingId() {
        log.debug("InstalledProduct.generateOfferingId enter");
        String offeringId = "";
        if (this.initialized) {
            String majorMinorVersion = SyncUtil.getMajorAndMinorVersion(this.getCurrentlyInstalledVersion());
            offeringId = "com.ibm.websphere." + this.productId + ".v" + majorMinorVersion;
        }
        log.debug("InstalledProduct.generateOfferingId exit");
        return offeringId;
    }

    private String[] getAllInstalledPaks(IPakUtils pakUtils) {
        log.debug("InstalledProduct.getAllInstalledPaks enter");
        String[] allPaks = this.getInstalledPaks(pakUtils, Boolean.FALSE, null);
        log.debug("InstalledProduct.getAllInstalledPaks exit");
        return allPaks;
    }

    private String[] getInstalledPaks(IPakUtils pakUtils, boolean primaryOnly, String packageType) {
        String trialProductId;
        String[] installedTrialPaks;
        log.debug("InstalledProduct.getAllInstalledPaks enter");
        String[] installedPakNames = pakUtils.getInstalledPakNames(this.installLocation, "/properties/version/nif/backup/", this.productId, packageType, primaryOnly);
        if (installedPakNames == null) {
            installedPakNames = new String[]{};
        }
        if ((installedTrialPaks = pakUtils.getInstalledPakNames(this.installLocation, "/properties/version/nif/backup/", trialProductId = String.valueOf(this.productId) + "TRIAL", packageType, primaryOnly)) == null) {
            installedTrialPaks = new String[]{};
        }
        String[] allPaks = new String[installedPakNames.length + installedTrialPaks.length];
        int allPaksPos = 0;
        int i = 0;
        while (i < installedTrialPaks.length) {
            allPaks[allPaksPos] = installedTrialPaks[i];
            ++i;
            ++allPaksPos;
        }
        i = 0;
        while (i < installedPakNames.length) {
            allPaks[allPaksPos] = installedPakNames[i];
            ++i;
            ++allPaksPos;
        }
        log.debug("InstalledProduct.getAllInstalledPaks exit");
        return allPaks;
    }

    private String[] getInstalledIfixMaintenanceName(IPakUtils pakUtils) {
        log.debug("InstalledProduct.getInstalledIfixMaintenanceName enter");
        String[] ifixMaintenanceName = pakUtils.getMaintenanceName(this.installLocation, this.productId, "IFIX", true);
        if (ifixMaintenanceName == null) {
            ifixMaintenanceName = new String[]{};
        }
        log.debug("InstalledProduct.getInstalledIfixMaintenanceName exit");
        return ifixMaintenanceName;
    }

    private String[] getAllVersionsInstalled(IPakUtils pakUtils) {
        log.debug("InstalledProduct.getAllVersionsInstalled enter");
        TreeSet<String> versions = new TreeSet<String>(new SyncUtil.VersionComparator());
        String currentVersion = pakUtils.getVersion(this.installLocation, this.productId);
        versions.add(currentVersion);
        versions.addAll(this.getAllPreviousVersionsInstalled(pakUtils, this.productId, currentVersion));
        String trialProductId = String.valueOf(this.productId) + "TRIAL";
        versions.addAll(this.getAllPreviousVersionsInstalled(pakUtils, trialProductId, currentVersion));
        log.debug("InstalledProduct.getAllVersionsInstalled exit");
        return versions.toArray(new String[versions.size()]);
    }

    private Set getAllPreviousVersionsInstalled(IPakUtils pakUtils, String productID, String currentVersion) {
        log.debug("InstalledProduct.getAllPreviousVersionsInstalled enter");
        String[] primaryPaks = pakUtils.getInstalledPakNames(this.installLocation, productID, Boolean.TRUE.booleanValue());
        TreeSet<String> versions = new TreeSet<String>();
        String[] stringArray = primaryPaks;
        int n = primaryPaks.length;
        int n2 = 0;
        while (n2 < n) {
            String primaryPak = stringArray[n2];
            String pakVersion = pakUtils.getPakVersion(this.installLocation, primaryPak);
            if (pakVersion != null && SyncUtil.compareVersion(pakVersion, currentVersion) < 0) {
                versions.add(pakUtils.getPakVersion(this.installLocation, primaryPak));
            }
            ++n2;
        }
        log.debug("InstalledProduct.getAllPreviousVersionsInstalled exit");
        return versions;
    }

    protected boolean isTrialProduct(IPakUtils pakUtils) {
        log.debug("InstalledProduct.isTrialProduct enter");
        boolean isTrialProduct = Boolean.FALSE;
        List<String> wasIds = Arrays.asList(SyncConstants.WAS_IDS);
        if (wasIds.contains(this.productId)) {
            isTrialProduct = !pakUtils.isThisPakInstalled(this.installLocation, "was.license.pak");
        }
        log.debug("InstalledProduct.isTrialProduct exit");
        return isTrialProduct;
    }

    protected String lookupProductName(IPakUtils pakUtils) {
        log.debug("InstalledProduct.lookupProductName enter");
        String name = pakUtils.getName(this.installLocation, this.productId);
        String version = pakUtils.getVersion(this.installLocation, this.productId);
        String productDes = !"".equals(name) ? Messages.bind((String)"{0} {1}", (Object)name, (Object)version) : "";
        log.debug("InstalledProduct.lookupProductName exit");
        return productDes;
    }

    @Override
    public String[] getInstalledVersions() {
        return this.installedVersions;
    }

    @Override
    public boolean isTrial() {
        return this.isTrial;
    }

    @Override
    public String getInstallLocation() {
        return this.installLocation;
    }

    @Override
    public String getProductId() {
        return this.productId;
    }

    @Override
    public String[] getInstalledPaks() {
        return this.installedPaks;
    }

    @Override
    public String getProductName() {
        return this.productName;
    }

    @Override
    public String[] getInstalledIfixes() {
        return this.installedIfixes;
    }

    @Override
    public String getCurrentlyInstalledVersion() {
        return this.initialized ? (this.installedVersions.length > 0 ? this.installedVersions[this.installedVersions.length - 1] : "0.0.0.0") : "";
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public int compareTo(Object arg0) {
        if (!(arg0 instanceof InstalledProduct)) {
            throw new ClassCastException("Type mismatch: Expecting an InstalledProduct object");
        }
        IInstalledProduct installedProduct = (IInstalledProduct)arg0;
        List<String> wasIds = Arrays.asList(SyncConstants.WAS_IDS);
        int compareValue = 0;
        compareValue = wasIds.contains(installedProduct.getProductId()) && wasIds.contains(this.productId) ? installedProduct.getProductId().compareTo(this.productId) : (wasIds.contains(this.productId) ? -1 : 1);
        return compareValue;
    }
}

