/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.resync.internal;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.api.IAgentJobType;
import com.ibm.cic.agent.core.api.ILocationCheck;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.MultiStatusUtil;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.logging.Logger;
import com.ibm.ws.resync.internal.Messages;
import com.ibm.ws.resync.internal.ResyncUtil;
import com.ibm.ws.sync.core.SyncLocation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ResyncCheckInFlow
implements ILocationCheck {
    private static final Logger log = Logger.getLogger(ResyncCheckInFlow.class);
    public static final String pluginId = "com.ibm.ws.sync.core";
    private static final String NEWLINE = "\n";

    public IStatus run(IProfile profile, IAgentJobType jobType, IProgressMonitor monitor) {
        IStatus retStatus = Status.OK_STATUS;
        if (Agent.getInstance().isSkipInstall()) {
            return retStatus;
        }
        if ((jobType.isInstall() || jobType.isModify() || jobType.isUpdate() || jobType.isRollback() || jobType.isUninstall()) && ResyncUtil.hasImportedEnabledOfferings(profile)) {
            if (monitor.isCanceled()) {
                return new Status(8, pluginId, Messages.OperationCancelled);
            }
            if (jobType.isRollback()) {
                Agent.getInstance().configureRepositoryGroup(monitor);
            }
            log.debug("Run in-flow resync check on location " + profile.getInstallLocation());
            SyncLocation syncLoc = new SyncLocation(profile.getInstallLocation());
            if (syncLoc.validateLocation().getSeverity() == 4) {
                log.debug("Base product is not found in " + profile.getInstallLocation());
                retStatus = jobType.isUninstall() ? this.constructPackageGroupNotAvailableStatus(2, true, profile.getProfileId()) : this.constructPackageGroupNotAvailableStatus(4, false, profile.getProfileId());
            } else {
                CicMultiStatus result = syncLoc.performCheck(monitor, true, false);
                if (result.getSeverity() == 4) {
                    log.debug("Error occurred when looking up " + profile.getInstallLocation());
                    SyncLocation.InstalledOffering[] invalidOfferings = syncLoc.getOfferingsWithInvalidVersions();
                    if (invalidOfferings != null && invalidOfferings.length > 0) {
                        log.debug("Detected required products or components with different version.");
                        retStatus = jobType.isUninstall() ? this.constructOfferingsWithInvalidVersionsMainStatus(2, true, invalidOfferings, (IStatus)result) : this.constructOfferingsWithInvalidVersionsMainStatus(4, false, invalidOfferings, (IStatus)result);
                    } else {
                        retStatus = jobType.isUninstall() ? this.getStatus(2, MultiStatusUtil.getFailureMessage((IStatus)result, (String)NEWLINE)) : this.getStatus(4, MultiStatusUtil.getFailureMessage((IStatus)result, (String)NEWLINE));
                    }
                }
            }
            if (retStatus.isOK() && syncLoc.requiresSynchronization() && syncLoc.getOfferingsToInstall().length > 0) {
                log.debug("Location " + profile.getInstallLocation() + " requires synchronization.");
                String[] offeringNotInSync = syncLoc.getAllOfferingsOutOfSync();
                retStatus = jobType.isUninstall() ? this.constructOfferingsNotInSyncMainStatus(2, true, profile.getProfileId(), offeringNotInSync) : this.constructOfferingsNotInSyncMainStatus(4, false, profile.getProfileId(), offeringNotInSync);
            }
            if (retStatus.isOK() && jobType.isRollback() && syncLoc.getOutOfSyncFixes().length > 0) {
                retStatus = Statuses.WARNING.get(Messages.IFixCheck_notInSync, new Object[]{profile.getProfileId(), Util.toString((Object[])syncLoc.getOutOfSyncFixes(), (Util.Formatter)Util.Formatter.DEFAULT)});
            }
        }
        if (!Agent.getInstance().isSilentMode()) {
            if (retStatus.getSeverity() == 4) {
                log.error(this.getLogMessage(retStatus));
            } else if (retStatus.getSeverity() == 2) {
                log.warning(this.getLogMessage(retStatus));
            }
        }
        return retStatus;
    }

    private String getLogMessage(IStatus status) {
        StringBuilder msg = new StringBuilder(String.valueOf(status.getMessage()) + NEWLINE);
        if (status.isMultiStatus()) {
            IStatus[] children;
            IStatus[] iStatusArray = children = status.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus element = iStatusArray[n2];
                msg.append(MultiStatusUtil.getFailureMessage((IStatus)element, (String)NEWLINE));
                ++n2;
            }
        }
        return msg.toString();
    }

    private IStatus constructOfferingsWithInvalidVersionsMainStatus(int severity, boolean isJobUninstall, SyncLocation.InstalledOffering[] offeringNotInSyncList, IStatus result) {
        boolean isOnePackageNotInSync = offeringNotInSyncList != null && offeringNotInSyncList.length == 1;
        String mainMessage = null;
        mainMessage = isJobUninstall ? (isOnePackageNotInSync ? Messages.UninstallResyncCheck_package_notInSync : Messages.UninstallResyncCheck_packages_notInSync) : (isOnePackageNotInSync ? Messages.InflowResyncCheck_package_notInSync : Messages.InflowResyncCheck_packages_notInSync);
        CicMultiStatus sMain = Statuses.ST.createMultiStatusFromStatus(this.getStatus(severity, mainMessage));
        sMain.add(this.getStatus(severity, MultiStatusUtil.getFailureMessage((IStatus)result, (String)NEWLINE)));
        return sMain;
    }

    private IStatus constructOfferingsNotInSyncMainStatus(int severity, boolean isJobUninstall, String profileId, String[] offeringNotInSyncList) {
        boolean isOnePackageNotInSync = offeringNotInSyncList != null && offeringNotInSyncList.length == 1;
        String mainMessage = null;
        String detailMessage = null;
        if (isJobUninstall) {
            if (isOnePackageNotInSync) {
                mainMessage = Messages.UninstallResyncCheck_package_notInSync;
                detailMessage = Messages.InflowResyncCheck_package_notInSync_detail_1;
            } else {
                mainMessage = Messages.UninstallResyncCheck_packages_notInSync;
                detailMessage = Messages.InflowResyncCheck_packages_notInSync_detail_1;
            }
        } else if (isOnePackageNotInSync) {
            mainMessage = Messages.InflowResyncCheck_package_notInSync;
            detailMessage = Messages.InflowResyncCheck_package_notInSync_detail_1;
        } else {
            mainMessage = Messages.InflowResyncCheck_packages_notInSync;
            detailMessage = Messages.InflowResyncCheck_packages_notInSync_detail_1;
        }
        IStatus sDetail_offeringList = this.constructOfferingsNotInSyncDetailStatus(severity, profileId, offeringNotInSyncList);
        CicMultiStatus sMain = Statuses.ST.createMultiStatusFromStatus(this.getStatus(severity, mainMessage));
        sMain.add(this.getStatus(severity, detailMessage));
        sMain.add(sDetail_offeringList);
        return sMain;
    }

    private IStatus constructOfferingsNotInSyncDetailStatus(int severity, String profileId, String[] offeringNotInSyncList) {
        boolean isOnePackageNotInSync = offeringNotInSyncList != null && offeringNotInSyncList.length == 1;
        String detailMessage = "";
        CicMultiStatus detailStatus = Statuses.ST.createMultiStatus();
        if (offeringNotInSyncList != null && offeringNotInSyncList.length > 0) {
            detailMessage = isOnePackageNotInSync ? NLS.bind((String)Messages.InflowResyncCheck_package_notInSync_detail_2, (Object)profileId) : NLS.bind((String)Messages.InflowResyncCheck_packages_notInSync_detail_2, (Object)profileId);
            detailStatus = Statuses.ST.createMultiStatusFromStatus(this.getStatus(severity, detailMessage));
            String[] stringArray = offeringNotInSyncList;
            int n = offeringNotInSyncList.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                detailStatus.add(this.getStatus(severity, element));
                ++n2;
            }
        }
        return detailStatus;
    }

    private IStatus constructPackageGroupNotAvailableStatus(int severity, boolean isJobUninstall, String profileId) {
        String mainMessage = NLS.bind((String)Messages.InflowResyncCheck_packageGroupNotAvailable, (Object)profileId);
        String detailMessage_1 = NLS.bind((String)Messages.InflowResyncCheck_packageGroupNotAvailable_detail_1, (Object)profileId);
        String detailMessage_2 = Messages.InflowResyncCheck_packageGroupNotAvailable_detail_2;
        String detailMessage_3 = "";
        String detailMessage_4 = "";
        if (isJobUninstall) {
            detailMessage_3 = Messages.UninstallResyncCheck_packageGroupNotAvailable_detail_3;
            detailMessage_4 = Messages.UninstallResyncCheck_packageGroupNotAvailable_detail_4;
        } else {
            detailMessage_3 = Messages.InflowResyncCheck_packageGroupNotAvailable_detail_3;
            detailMessage_4 = Messages.InflowResyncCheck_packageGroupNotAvailable_detail_4;
        }
        CicMultiStatus detailStatus_2 = Statuses.ST.createMultiStatusFromStatus(this.getStatus(severity, detailMessage_2));
        detailStatus_2.add(this.getStatus(severity, detailMessage_3));
        detailStatus_2.add(this.getStatus(severity, detailMessage_4));
        CicMultiStatus mainStatus = Statuses.ST.createMultiStatusFromStatus(this.getStatus(severity, mainMessage));
        mainStatus.add(this.getStatus(severity, detailMessage_1));
        mainStatus.add((IStatus)detailStatus_2);
        return mainStatus;
    }

    private IStatus getStatus(int severity, String message) {
        return new Status(severity, pluginId, message);
    }
}

