/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.transports.httpclient.internal.ntlm.portable;

import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.DecodeBytes;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.LogNTLMMessage;

public class MessageField {
    String fieldName;
    int len;
    int maxLen;
    int offset;
    byte[] data;

    public MessageField(DecodeBytes decode, String name) throws DecodeBytes.DecodeBytesException {
        this.fieldName = name;
        this.len = decode.getNextLen();
        this.maxLen = decode.getNextLen();
        this.offset = decode.getNextOffset();
        this.data = decode.bytes(this.offset, this.len);
    }

    public int getLen() {
        return this.len;
    }

    public String toString() {
        if (this.maxLen != this.len) {
            return String.valueOf(this.fieldName) + " len=" + this.len + " maxLen=" + this.maxLen + " offset=" + this.offset + " " + LogNTLMMessage.dataAsString(this.data);
        }
        return String.valueOf(this.fieldName) + " len=" + this.len + " offset=" + this.offset + " " + LogNTLMMessage.dataAsString(this.data);
    }

    public byte[] getData() {
        return this.data;
    }

    public String getName() {
        return this.fieldName;
    }
}

