/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.transports.httpclient.internal.ntlm.portable;

import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.BitUtil;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.Messages;

public class DecodeBytes {
    protected byte[] bytes;
    private int pos;

    public DecodeBytes(byte[] bytes) {
        this(bytes, 0);
    }

    public DecodeBytes(byte[] bytes, int pos) {
        this.bytes = bytes;
        this.pos = pos;
    }

    public int getPos() {
        return this.pos;
    }

    public int length() {
        return this.bytes.length;
    }

    public byte[] bytes(int offset, int len) {
        byte[] b = new byte[len];
        System.arraycopy(this.bytes, offset, b, 0, len);
        return b;
    }

    public short getNextLen() throws DecodeBytesException {
        short s = BitUtil.LEtoShort(this.bytes, this.pos);
        if (s < 0) {
            throw new DecodeBytesException(NLS.bind((String)Messages.DecodeBytes_negativeLengthInvalid, (Object)s));
        }
        this.pos += 2;
        return s;
    }

    public short getNextShort() {
        short s = BitUtil.LEtoShort(this.bytes, this.pos);
        this.pos += 2;
        return s;
    }

    public int getNextInt() {
        int i = BitUtil.LEtoInt(this.bytes, this.pos);
        this.pos += 4;
        return i;
    }

    public int getNextOffset() throws DecodeBytesException {
        int i = BitUtil.LEtoInt(this.bytes, this.pos);
        if (i < 0) {
            throw new DecodeBytesException(NLS.bind((String)Messages.DecodeBytes_negativeOffsetInvalid, (Object)i));
        }
        this.pos += 4;
        return i;
    }

    public byte[] getNextBytes(int n) {
        byte[] buf = new byte[n];
        System.arraycopy(this.bytes, this.pos, buf, 0, n);
        this.pos += n;
        return buf;
    }

    public void skipNextBytes(int n) {
        this.pos += n;
    }

    public void checkBytes(String what, byte[] expected) throws DecodeBytesException {
        if (this.bytes.length - this.pos < expected.length) {
            throw new DecodeBytesException(NLS.bind((String)Messages.DecodeBytes_expectedBytesNotFound, (Object[])new Object[]{what, BitUtil.bytesToHexString(expected), BitUtil.bytesToHexString(BitUtil.subArray(this.bytes, this.pos, this.bytes.length))}));
        }
        int i = this.pos;
        while (i < expected.length + this.pos) {
            byte b = this.bytes[i];
            if (b != expected[i - this.pos]) {
                throw new DecodeBytesException(NLS.bind((String)Messages.DecodeBytes_expectedBytesNotFound, (Object[])new Object[]{what, BitUtil.bytesToHexString(expected), BitUtil.bytesToHexString(BitUtil.subArray(this.bytes, this.pos, this.pos + expected.length))}));
            }
            ++i;
        }
        this.pos += expected.length;
    }

    public static class DecodeBytesException
    extends Exception {
        public DecodeBytesException() {
        }

        public DecodeBytesException(String message, Throwable cause) {
            super(message, cause);
        }

        public DecodeBytesException(String message) {
            super(message);
        }

        public DecodeBytesException(Throwable cause) {
            super(cause);
        }
    }
}

