/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.transports.httpclient;

import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.transports.httpclient.Activator;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.Plugin;

public class JCLToCommonsLogAdapter
implements Log {
    static final Logger myLog = Logger.getLogger(JCLToCommonsLogAdapter.class, (Plugin)Activator.getDefault());
    private Logger log;
    private Logger logTrace;
    private static final String ORG_APACHE_COMMONS_LOGGING_LOG_CLASS = "org.apache.commons.logging.Log";
    static String previousLogClassName = null;
    private static ArrayList listeners = new ArrayList();

    public static synchronized void addCreateListener(ICreateListener listener) {
        listeners.add(listener);
    }

    public static synchronized void removeCreateListener(ICreateListener listener) {
        listeners.remove(listener);
    }

    public static void setup() {
        previousLogClassName = System.getProperty(ORG_APACHE_COMMONS_LOGGING_LOG_CLASS);
        String logClassname = JCLToCommonsLogAdapter.class.getName();
        System.setProperty(ORG_APACHE_COMMONS_LOGGING_LOG_CLASS, logClassname);
    }

    public JCLToCommonsLogAdapter(String name) {
        this.log = Logger.getLoggerUsingDebug((String)name, (Plugin)Activator.getDefault());
        Logger.LogStackFilter stackFilter = new Logger.LogStackFilter(){

            public boolean isLogger(StackTraceElement ste) {
                return ste.getClassName().equals(JCLToCommonsLogAdapter.class.getName());
            }
        };
        this.log.setStackFilter(stackFilter);
        String nameTrace = String.valueOf(name) + ".trace";
        this.logTrace = Logger.getLoggerUsingDebug((String)nameTrace, (Plugin)Activator.getDefault());
        this.logTrace.setStackFilter(stackFilter);
        JCLToCommonsLogAdapter.created(name, this.log, this.logTrace);
        myLog.debug("Adapting {0}", new Object[]{this.log});
    }

    private static void created(String name, Logger log, Logger logTrace) {
        for (ICreateListener listener : listeners) {
            listener.created(name, log, logTrace);
        }
    }

    public void debug(Object arg0) {
        if (arg0 instanceof String) {
            String response = (String)arg0;
            if (response.startsWith(">> \"Authorization:")) {
                this.log.debug(">> \"Authorization: ****** \"");
                return;
            }
            if (response.startsWith(">> \"Proxy-Authorization:")) {
                this.log.debug(">> \"Proxy-Authorization: ****** \"");
                return;
            }
        }
        this.log.debug(arg0);
    }

    public void debug(Object arg0, Throwable arg1) {
        this.log.debug(String.valueOf(arg0), new Object[]{arg1});
    }

    public void error(Object arg0) {
        this.log.error(arg0.toString());
    }

    public void error(Object arg0, Throwable arg1) {
        this.log.error(arg1, String.valueOf(arg0), new Object[0]);
    }

    public void fatal(Object arg0) {
        this.error(arg0);
    }

    public void fatal(Object arg0, Throwable arg1) {
        this.error(arg0, arg1);
    }

    public void info(Object arg0) {
        this.log.info(arg0.toString());
    }

    public void info(Object arg0, Throwable arg1) {
        this.log.info(String.valueOf(arg0), new Object[]{arg1});
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugLoggable();
    }

    public boolean isErrorEnabled() {
        return this.log.isErrorLoggable();
    }

    public boolean isFatalEnabled() {
        return this.isErrorEnabled();
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoLoggable();
    }

    public boolean isTraceEnabled() {
        return this.logTrace.isDebugLoggable();
    }

    public boolean isWarnEnabled() {
        return this.log.isWarningLoggable();
    }

    public void trace(Object arg0) {
        this.logTrace.debug(arg0);
    }

    public void trace(Object arg0, Throwable arg1) {
        this.logTrace.debug(String.valueOf(arg0), new Object[]{arg1});
    }

    public void warn(Object arg0) {
        this.log.warning(arg0.toString());
    }

    public void warn(Object arg0, Throwable arg1) {
        this.log.warning(String.valueOf(arg0), new Object[]{arg1});
    }

    static interface ICreateListener {
        public void created(String var1, Logger var2, Logger var3);
    }
}

