/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.transports.httpclient;

import com.ibm.cic.common.downloads.CredentialInfo;
import com.ibm.cic.common.downloads.CredentialRequested;
import com.ibm.cic.common.downloads.handlerImpl.AbstractAuthenticator;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.auth.RFC2617Scheme;

public class HttpCredentialsProvider
implements CredentialsProvider {
    private static final String SCHEME_NAME_NTLM = "ntlm";
    public static final HttpCredentialsProvider INSTANCE = new HttpCredentialsProvider();
    private final AbstractAuthenticator authenticator = new AbstractAuthenticator(){

        protected String getTraceName() {
            return "HttpClientNonProxyAuthenticator";
        }
    };

    private HttpCredentialsProvider() {
    }

    public Credentials getCredentials(AuthScheme scheme, String host, int port, boolean proxy) throws CredentialsNotAvailableException {
        if (!(scheme instanceof RFC2617Scheme) && !scheme.getSchemeName().equals(SCHEME_NAME_NTLM)) {
            throw new CredentialsNotAvailableException("Unsupported Authentication scheme");
        }
        CredentialRequested requested = new CredentialRequested(scheme.getSchemeName(), host, port, scheme.getRealm(), Boolean.valueOf(proxy));
        this.authenticator.setNotAuthorized(requested);
        AbstractAuthenticator.CredentialResult credResult = this.authenticator.getCredentials(requested, true);
        if (credResult != null) {
            if (credResult.getStatus().isOK()) {
                CredentialInfo credInfo = credResult.getCredentialInfo();
                if (scheme instanceof RFC2617Scheme) {
                    return new CicUsernamePasswordCredentials(credInfo.getUid(), credInfo.getPwd());
                }
                if (scheme.getSchemeName().equals(SCHEME_NAME_NTLM)) {
                    String netbiosHostThisComputer = "";
                    return new CicNTCredentials(credInfo.getUid(), credInfo.getPwd(), netbiosHostThisComputer, credInfo.getDomain());
                }
            }
            assert (credResult.getStatus().matches(8));
        }
        return null;
    }

    public AbstractAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    private static class CicNTCredentials
    extends NTCredentials {
        public CicNTCredentials(String userName, String password, String host, String domain) {
            super(userName, password, host, domain);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getUserName());
            sb.append(":");
            sb.append(CredentialInfo.maskPassword((String)this.getPassword()));
            sb.append("@");
            sb.append(this.getHost());
            sb.append(".");
            sb.append(this.getDomain());
            return sb.toString();
        }
    }

    private static class CicUsernamePasswordCredentials
    extends UsernamePasswordCredentials {
        public CicUsernamePasswordCredentials(String userName, String password) {
            super(userName, password);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getUserName());
            sb.append(":");
            sb.append(CredentialInfo.maskPassword((String)this.getPassword()));
            return sb.toString();
        }
    }
}

