/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.logging.parser;

import com.ibm.cic.common.logging.Level;
import com.ibm.cic.common.logging.LogEntry;
import com.ibm.cic.common.logging.LogUtil;
import com.ibm.cic.common.logging.parser.MessageRecord;
import com.ibm.cic.common.logging.parser.ThrownRecord;
import java.util.ArrayList;
import java.util.List;

public class EntryRecord {
    private final int num;
    private final long time;
    private final String elapsedTime;
    private int level;
    private final String thread;
    private final String uid;
    private String logger;
    private String callingClass;
    private String callingMethod;
    private MessageRecord message;
    private ThrownRecord thrown;
    private List children;
    private EntryRecord parent;

    public EntryRecord(EntryRecord record) {
        this(record.getNum(), record.getTime(), record.getLevel(), record.getElapsedTime(), record.getThread(), record.getUid());
    }

    public EntryRecord(LogEntry entry) {
        this(entry.getNum(), entry.getTime(), entry.getLevel(), "0", entry.getThreadName(), entry.getUid());
        this.logger = EntryRecord.formatObject(entry.getLoggerName());
        this.callingClass = EntryRecord.formatObject(entry.getCallingClass());
        this.callingMethod = EntryRecord.formatObject(entry.getCallingMethod());
    }

    EntryRecord(int num, long time, int level, String elapsedTime, String threadName, String uid) {
        this.num = num;
        this.time = time;
        this.level = level;
        this.elapsedTime = elapsedTime;
        this.thread = threadName;
        this.uid = uid;
    }

    private static String formatObject(Object obj) {
        return LogUtil.escape(LogUtil.toString(obj));
    }

    public String toString() {
        return String.valueOf(Level.getName(this.level)) + ": " + this.message;
    }

    public int getNum() {
        if (this.parent != null) {
            return this.parent.getNum();
        }
        return this.num;
    }

    public long getTime() {
        if (this.parent != null) {
            return this.parent.getTime();
        }
        return this.time;
    }

    public String getElapsedTime() {
        if (this.parent != null) {
            return this.parent.getElapsedTime();
        }
        return this.elapsedTime;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    void setLogger(String logger) {
        this.logger = logger;
    }

    public String getLogger() {
        if (this.parent != null) {
            return this.parent.getLogger();
        }
        return this.logger;
    }

    void setCallingClass(String clazz) {
        this.callingClass = clazz;
    }

    public String getCallingClass() {
        if (this.parent != null) {
            return this.parent.getCallingClass();
        }
        return this.callingClass;
    }

    void setCallingMethod(String method) {
        this.callingMethod = method;
    }

    public String getCallingMethod() {
        if (this.parent != null) {
            return this.parent.getCallingMethod();
        }
        return this.callingMethod;
    }

    public String getThread() {
        if (this.parent != null) {
            return this.parent.getThread();
        }
        return this.thread;
    }

    public String getUid() {
        if (this.parent != null) {
            return this.parent.getUid();
        }
        return this.uid;
    }

    public MessageRecord getMessageRecord() {
        if (this.message == null) {
            this.message = new MessageRecord();
        }
        return this.message;
    }

    public ThrownRecord getThrownRecord() {
        if (this.parent != null) {
            return this.parent.getThrownRecord();
        }
        if (this.thrown == null) {
            this.thrown = new ThrownRecord();
        }
        return this.thrown;
    }

    public void addChild(EntryRecord entry) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(entry);
        entry.parent = this;
    }

    public List getChildren() {
        return this.children;
    }

    public EntryRecord getParent() {
        return this.parent;
    }
}

