/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.logging;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.utils.XMLParser;
import com.ibm.cic.common.logging.LogUtil;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.logging.Translator;
import com.ibm.cic.common.logging.parser.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ParserWriter
extends XMLParser {
    XMLWriter writer;
    private static final String XML_HEADER = "version=\"1.0\" encoding=\"{0}\" standalone=\"no\"";
    private Translator tr;

    public void filter(InputStream in, OutputStream out, Translator t) throws SAXException, IOException, ParserConfigurationException {
        this.tr = t;
        this.writer = new XMLWriter(out);
        this.writer.processingInstruction("xml", NLS.bind((String)XML_HEADER, (Object)"UTF-8"));
        this.getParser().parse(in, (DefaultHandler)this);
        this.writer.close();
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes attr) {
        String data = this.finishCharacters();
        if (data != null) {
            this.writer.cdata(this.tr.retranslate(data));
        }
        this.writer.startElement(name, attr);
    }

    @Override
    public void processingInstruction(String target, String data) {
        this.writer.processingInstruction(target, data);
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        String data = this.finishCharacters();
        if (data != null) {
            if (name.equals("key") || name.equals("arg") || name.equals("message")) {
                data = this.tr.retranslate(data);
            }
            this.writer.endElement(name, data);
        } else {
            this.writer.endElement(name);
        }
    }

    public ParserWriter(OutputStream out) {
        this(ComIbmCicCommonCorePlugin.getBundleContext());
    }

    protected ParserWriter(BundleContext context) {
        super(context, ComIbmCicCommonCorePlugin.getPluginId());
        this.context = context;
    }

    @Override
    protected String getErrorMessage() {
        return Messages.CicLogParser_error_parsing_log_record;
    }

    @Override
    protected Logger getLogger() {
        return Logger.getLogger(ParserWriter.class);
    }

    @Override
    protected Object getRootObject() {
        return null;
    }

    @Override
    protected String processCharacters(String trimmedChars) {
        return trimmedChars;
    }

    private static class XMLWriter {
        private final PrintWriter pw;
        private static final char INDENT = ' ';
        private int indent = 0;

        public XMLWriter(OutputStream out) throws UnsupportedEncodingException {
            this.pw = new PrintWriter((Writer)new OutputStreamWriter(out, "UTF-8"), true);
        }

        public void endElement(String name, Object data) {
            String text;
            if (data != null && (text = LogUtil.fixNewlines(LogUtil.escape(LogUtil.toString(data)))) != null) {
                if (text.indexOf(LogUtil.NEWLINE) > 0) {
                    this.newline();
                    this.pw.print(text);
                } else {
                    this.pw.print(text);
                }
                this.end(name);
                --this.indent;
            }
        }

        private void end(String name) {
            this.pw.print('<');
            this.pw.print('/');
            this.pw.print(name);
            this.pw.print('>');
        }

        public void endElement(String name) {
            this.newline();
            this.indent();
            this.end(name);
            this.newline();
            --this.indent;
        }

        private void indent() {
            int i = 0;
            while (i < this.indent) {
                this.pw.print(' ');
                ++i;
            }
        }

        public void cdata(String string) {
            this.newline();
            this.pw.print(string);
        }

        public void startElement(String name, Attributes attr) {
            this.newline();
            this.indent();
            ++this.indent;
            this.pw.print('<');
            this.pw.print(name);
            int i = 0;
            while (i < attr.getLength()) {
                this.pw.print(' ');
                this.pw.print(attr.getLocalName(i));
                this.pw.print('=');
                this.pw.print('\'');
                this.pw.print(attr.getValue(i));
                this.pw.print('\'');
                ++i;
            }
            this.pw.print('>');
        }

        private void newline() {
            this.pw.print(LogUtil.NEWLINE);
        }

        public void processingInstruction(String target, String data) {
            this.pw.print('<');
            this.pw.print('?');
            this.pw.print(target);
            this.pw.print(' ');
            this.pw.print(data);
            this.pw.print('?');
            this.pw.print('>');
            this.newline();
        }

        public void close() {
            this.pw.close();
        }
    }
}

