/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.logging;

import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.logging.ParserWriter;
import com.ibm.cic.common.logging.Translator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;

public class CicLogRelocalizer {
    private final Translator retranslator;

    public CicLogRelocalizer(Locale targetLocale) {
        this.retranslator = new Translator(targetLocale);
    }

    public void export(File in, File out) {
        try {
            this.export(new FileInputStream(in), new FileOutputStream(out));
        }
        catch (FileNotFoundException e) {
            ExceptionUtil.debugLogFileNotFoundException(e);
        }
    }

    public void export(InputStream in, OutputStream out) {
        ParserWriter pw = new ParserWriter(out);
        try {
            pw.filter(in, out, this.retranslator);
        }
        catch (Exception e) {
            ExceptionUtil.debugLogToReview(e);
        }
    }
}

