/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads.handlerImpl;

import com.ibm.cic.common.downloads.DownloadCanceledException;
import com.ibm.cic.common.downloads.DownloadHandler;
import com.ibm.cic.common.downloads.DownloadHandlerRequest;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadStream;
import com.ibm.cic.common.downloads.IHasIsCanceled;
import com.ibm.cic.common.downloads.ITransferMonitor;
import com.ibm.cic.common.downloads.handlerImpl.AuthenticationContext;
import com.ibm.cic.common.downloads.handlerImpl.DownloadHandlerUtil;
import com.ibm.cic.common.downloads.handlerImpl.RequestRetryHandler;
import java.io.IOException;

public class RequestRetry {
    public static IDownloadStream openStreamAtRangeWithRetry(AuthenticationContext ac, IRequestWithoutRetry handler, DownloadHandlerRequest.OpenStreamForRangeRequest request, ITransferMonitor transferPerformance, IContentInfo[] outContentInfo) throws IOException {
        if (outContentInfo != null && outContentInfo.length != 1) {
            throw new IllegalArgumentException();
        }
        IHasIsCanceled cancelMonitor = DownloadHandler.getCancelMonitor(request);
        RequestRetryHandler retryHandler = new RequestRetryHandler(ac, cancelMonitor, 2);
        int executionCount = 1;
        while (true) {
            try {
                return handler.openStreamAtRangeNoRetry(ac, request, transferPerformance, outContentInfo);
            }
            catch (IOException e) {
                boolean retry = retryHandler.shouldRetry(request, request.getUrlString(), e, executionCount);
                if (!retry) {
                    DownloadHandlerUtil.rethrowOpenStreamException(e);
                }
                ++executionCount;
                continue;
            }
            break;
        }
    }

    public static boolean existsWithRetry(AuthenticationContext ac, IRequestWithoutRetry handler, DownloadHandlerRequest.ExistsRequest request, IHasIsCanceled cancelMonitor) throws IOException {
        if (cancelMonitor.isCanceled()) {
            throw DownloadCanceledException.create(request, null);
        }
        RequestRetryHandler retryHandler = new RequestRetryHandler(ac, cancelMonitor, 2);
        int executionCount = 1;
        while (true) {
            try {
                return handler.existsNoRetry(ac, request, cancelMonitor);
            }
            catch (IOException e) {
                boolean retry = retryHandler.shouldRetry(request, request.getUrlString(), e, executionCount);
                if (!retry) {
                    DownloadHandlerUtil.rethrowExistsException(e);
                }
                ++executionCount;
                continue;
            }
            break;
        }
    }

    public static interface IRequestWithoutRetry {
        public IDownloadStream openStreamAtRangeNoRetry(AuthenticationContext var1, DownloadHandlerRequest.OpenStreamForRangeRequest var2, ITransferMonitor var3, IContentInfo[] var4) throws IOException;

        public boolean existsNoRetry(AuthenticationContext var1, DownloadHandlerRequest.ExistsRequest var2, IHasIsCanceled var3) throws IOException;
    }
}

