/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.internal.downloads.TransferSession;
import com.ibm.cic.common.downloads.ITransferSession;
import com.ibm.cic.common.downloads.ITransferSessionListener;
import java.util.ArrayList;
import java.util.List;

public class TransferSessionManager {
    public static final TransferSessionManager INSTANCE = new TransferSessionManager();
    private final List<ITransferSessionListener> listeners = new ArrayList<ITransferSessionListener>();
    private ITransferSession defaultSession;

    private TransferSessionManager() {
    }

    public synchronized ITransferSession getSession() {
        if (this.defaultSession == null) {
            this.defaultSession = new TransferSession(TransferSessionManager.class.toString());
        }
        return this.defaultSession;
    }

    public synchronized void addSessionListener(ITransferSessionListener listener) {
        this.getSession();
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized void closeDefaultSession() {
        if (this.defaultSession != null) {
            for (ITransferSessionListener listener : this.listeners) {
                listener.close(this.defaultSession);
            }
            this.listeners.clear();
            this.defaultSession = null;
        }
    }
}

