/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.downloads.IHasIsCanceled;
import com.ibm.cic.common.downloads.ITransferMonitor;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;

public class TransferMonitor
implements ITransferMonitor {
    private IHasIsCanceled monitorCanceled;
    private final LinkedList listeners = new LinkedList();

    public TransferMonitor(IHasIsCanceled monitorCanceled) {
        this.monitorCanceled = monitorCanceled;
    }

    public TransferMonitor(final IProgressMonitor monitor) {
        this.setMonitorCanceled(new IHasIsCanceled(){

            @Override
            public boolean isCanceled() {
                return monitor != null ? monitor.isCanceled() : false;
            }
        });
    }

    @Override
    public boolean needsUpdates() {
        return this.listeners.size() > 0;
    }

    public TransferMonitor() {
        this((IHasIsCanceled)null);
    }

    public void setMonitorCanceled(IHasIsCanceled monitorCanceled) {
        this.monitorCanceled = monitorCanceled;
    }

    @Override
    public void addListener(ITransferMonitor transferPerformance) {
        if (!this.listeners.contains(transferPerformance)) {
            this.listeners.add(transferPerformance);
        }
    }

    @Override
    public void removeListener(ITransferMonitor transferPerformance) {
        this.listeners.remove(transferPerformance);
    }

    @Override
    public void noTransferNecessary() {
        ITransferMonitor[] probes;
        ITransferMonitor[] iTransferMonitorArray = probes = this.listeners.toArray(new ITransferMonitor[this.listeners.size()]);
        int n = probes.length;
        int n2 = 0;
        while (n2 < n) {
            ITransferMonitor probe = iTransferMonitorArray[n2];
            probe.noTransferNecessary();
            ++n2;
        }
    }

    @Override
    public void done() {
        ITransferMonitor[] probes;
        ITransferMonitor[] iTransferMonitorArray = probes = this.listeners.toArray(new ITransferMonitor[this.listeners.size()]);
        int n = probes.length;
        int n2 = 0;
        while (n2 < n) {
            ITransferMonitor probe = iTransferMonitorArray[n2];
            probe.done();
            ++n2;
        }
    }

    @Override
    public void startTransfer(long bytesTotal, long bytesToTransfer) {
        ITransferMonitor[] probes;
        ITransferMonitor[] iTransferMonitorArray = probes = this.listeners.toArray(new ITransferMonitor[this.listeners.size()]);
        int n = probes.length;
        int n2 = 0;
        while (n2 < n) {
            ITransferMonitor probe = iTransferMonitorArray[n2];
            probe.startTransfer(bytesTotal, bytesToTransfer);
            ++n2;
        }
    }

    @Override
    public void update(int percentDone, long bytesTransferred, long bytesToTransferTotal, long bytesPerSecondTotal, long bytesPerLastSecond) {
        ITransferMonitor[] probes;
        ITransferMonitor[] iTransferMonitorArray = probes = this.listeners.toArray(new ITransferMonitor[this.listeners.size()]);
        int n = probes.length;
        int n2 = 0;
        while (n2 < n) {
            ITransferMonitor probe = iTransferMonitorArray[n2];
            probe.update(percentDone, bytesTransferred, bytesToTransferTotal, bytesPerSecondTotal, bytesPerLastSecond);
            ++n2;
        }
    }

    @Override
    public boolean isCanceled() {
        ITransferMonitor[] probes;
        ITransferMonitor[] iTransferMonitorArray = probes = this.listeners.toArray(new ITransferMonitor[this.listeners.size()]);
        int n = probes.length;
        int n2 = 0;
        while (n2 < n) {
            ITransferMonitor probe = iTransferMonitorArray[n2];
            if (probe.isCanceled()) {
                return true;
            }
            ++n2;
        }
        return this.monitorCanceled != null ? this.monitorCanceled.isCanceled() : false;
    }
}

