/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.internal.downloads.ProgressMessage;
import com.ibm.cic.common.downloads.ITransferMonitor;
import com.ibm.cic.common.downloads.ProgressInputStream;
import com.ibm.cic.common.downloads.TransferMonitor;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class ProgressMonitorInputStream
extends ProgressInputStream {
    private final IProgressMonitor monitor;
    private String lastMsg;
    private ProgressMessage progressMsg;

    public ProgressMonitorInputStream(InputStream stream, long bytesTotal, long bytesToTransfer, ITransferMonitor transferPerformance, IProgressMonitor monitor) {
        this(stream, bytesTotal, bytesToTransfer, "", transferPerformance, monitor);
    }

    public ProgressMonitorInputStream(InputStream stream, long bytesTotal, long bytesToTransfer, String taskName, IProgressMonitor monitor) {
        this(stream, bytesTotal, bytesToTransfer, taskName, null, monitor);
    }

    public ProgressMonitorInputStream(InputStream stream, long bytesTotal, long bytesToTransfer, final String taskName, ITransferMonitor argOtherTransferPerformance, IProgressMonitor monitor) {
        super(null, stream, bytesTotal, bytesToTransfer, null, false);
        this.monitor = monitor;
        if (argOtherTransferPerformance == null && this.monitor instanceof NullProgressMonitor) {
            return;
        }
        final boolean isNullProgressMonitor = this.monitor instanceof NullProgressMonitor;
        final ITransferMonitor otherTransferPerformance = argOtherTransferPerformance != null ? argOtherTransferPerformance : new TransferMonitor(monitor);
        this.setTransferPerformance(new TransferMonitor(monitor){

            @Override
            public boolean needsUpdates() {
                return true;
            }

            @Override
            public void noTransferNecessary() {
                otherTransferPerformance.noTransferNecessary();
            }

            @Override
            public void startTransfer(long pbytesTotal, long pbytesToTransfer) {
                otherTransferPerformance.startTransfer(pbytesTotal, pbytesToTransfer);
                if (isNullProgressMonitor) {
                    return;
                }
                if (pbytesToTransfer != -1L) {
                    ProgressMonitorInputStream.this.monitor.beginTask("", 100);
                }
                ProgressMonitorInputStream.this.progressMsg = new ProgressMessage();
                ProgressMonitorInputStream.this.progressMsg.startTransfer(pbytesToTransfer);
                ProgressMonitorInputStream.this.lastMsg = "";
            }

            @Override
            public void done() {
                otherTransferPerformance.done();
                if (isNullProgressMonitor) {
                    return;
                }
                ProgressMonitorInputStream.this.monitor.done();
            }

            @Override
            public void update(int percentDone, long bytesTransferred, long pbytesTotal, long bytesPerSecondTotal, long bytesPerLastSecond) {
                String rateMsg;
                String curMsg;
                if (isNullProgressMonitor) {
                    return;
                }
                otherTransferPerformance.update(percentDone, bytesTransferred, pbytesTotal, bytesPerSecondTotal, bytesPerLastSecond);
                if (percentDone != -1) {
                    ProgressMonitorInputStream.this.monitor.worked(percentDone);
                }
                if (!(curMsg = NLS.bind((String)"{0} {1}", (Object)taskName, (Object)(rateMsg = ProgressMonitorInputStream.this.progressMsg.getRateMessage(percentDone, bytesTransferred, pbytesTotal, bytesPerSecondTotal, bytesPerLastSecond)))).equals(ProgressMonitorInputStream.this.lastMsg)) {
                    ProgressMonitorInputStream.this.monitor.subTask(curMsg);
                    ProgressMonitorInputStream.this.lastMsg = curMsg;
                }
            }
        });
        this.start();
    }
}

