/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.downloads.IDownloadListener;
import com.ibm.cic.common.downloads.ITransferMonitor;
import com.ibm.cic.common.downloads.TransferMonitor;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

public class ProgressInputStream
extends FilterInputStream {
    protected EmitDownloadEvents emitDownloadEvents;
    protected ITransferMonitor transferPerformance;
    protected boolean needsUpdates;
    private final long bytesTotal;
    private final long bytesToTransfer;
    private long bytesTransferred = 0L;
    private long bytesTransferredLastInterval;
    private long startTime;
    private long timeToUpdateProgress;
    private static final int UPDATE_INTERVAL = 1;
    private static final long UNKNOWN_SIZE = -1L;

    public ProgressInputStream(EmitDownloadEvents emitDownloadEvents, InputStream stream, long bytesTotal, long bytesToTransfer, ITransferMonitor transferPerformance, boolean doStart) {
        super(stream);
        this.setContext(emitDownloadEvents);
        this.bytesTotal = bytesTotal;
        this.bytesToTransfer = bytesToTransfer;
        this.transferPerformance = transferPerformance == null ? new TransferMonitor() : transferPerformance;
        this.bytesTransferredLastInterval = 0L;
        if (doStart) {
            this.start();
        }
    }

    protected void start() {
        this.needsUpdates = this.transferPerformance.needsUpdates();
        if (!this.needsUpdates) {
            return;
        }
        this.startTime = System.currentTimeMillis();
        this.transferPerformance.startTransfer(this.bytesTotal, this.bytesToTransfer);
        if (this.emitDownloadEvents != null) {
            this.emitDownloadEvents.getFire().openReadingStream(this.emitDownloadEvents.getAccess());
        }
        this.timeToUpdateProgress = this.startTime;
        this.update();
    }

    protected void setContext(EmitDownloadEvents emitDownloadEvents) {
        this.emitDownloadEvents = emitDownloadEvents;
    }

    protected void setTransferPerformance(ITransferMonitor transferPerformance) {
        this.transferPerformance = transferPerformance;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.update(true);
            this.transferPerformance.done();
            if (this.emitDownloadEvents != null) {
                this.emitDownloadEvents.getFire().closeReadingStream(this.emitDownloadEvents.getAccess());
            }
        }
    }

    @Override
    public int read() throws IOException {
        try {
            int result;
            if (this.emitDownloadEvents != null) {
                this.emitDownloadEvents.getFire().startReadingStream(this.emitDownloadEvents.getAccess());
            }
            if ((result = super.read()) != -1) {
                ++this.bytesTransferred;
            }
            int n = result;
            return n;
        }
        catch (InterruptedIOException e) {
            this.bytesTransferred += (long)e.bytesTransferred;
            throw e;
        }
        finally {
            if (this.emitDownloadEvents != null) {
                this.emitDownloadEvents.getFire().endReadingStream(this.emitDownloadEvents.getAccess());
            }
            this.update();
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int result;
            if (this.emitDownloadEvents != null) {
                this.emitDownloadEvents.getFire().startReadingStream(this.emitDownloadEvents.getAccess());
            }
            if ((result = super.read(b, off, len)) != -1) {
                this.bytesTransferred += (long)result;
            }
            int n = result;
            return n;
        }
        catch (InterruptedIOException e) {
            this.bytesTransferred += (long)e.bytesTransferred;
            throw e;
        }
        finally {
            if (this.emitDownloadEvents != null) {
                this.emitDownloadEvents.getFire().endReadingStream(this.emitDownloadEvents.getAccess());
            }
            this.update();
        }
    }

    protected void update() {
        this.update(false);
    }

    protected void update(boolean force) {
        if (!this.needsUpdates) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (force || currentTime >= this.timeToUpdateProgress) {
            int pct = -1;
            if (this.bytesToTransfer != -1L) {
                pct = this.bytesToTransfer > 0L ? (int)(100L * this.bytesTransferred / this.bytesToTransfer) : 100;
            }
            long totalMs = currentTime - this.startTime;
            long bpsTotal = -1L;
            long bpsLast = -1L;
            long updateIntervalMs = currentTime - (this.timeToUpdateProgress - 1000L);
            if (totalMs > 0L) {
                bpsTotal = this.bytesTransferred * 1000L / totalMs;
            }
            if (updateIntervalMs > 0L) {
                bpsLast = (this.bytesTransferred - this.bytesTransferredLastInterval) * 1000L / updateIntervalMs;
            }
            this.transferPerformance.update(pct, this.bytesTransferred, this.bytesToTransfer, bpsTotal, bpsLast);
            this.timeToUpdateProgress = currentTime + 1000L;
            this.bytesTransferredLastInterval = this.bytesTransferred;
        } else {
            ITransferMonitor.log.debug("Ignoring update call due to update frequency");
        }
    }

    public long getBytesToTransfer() {
        return this.bytesToTransfer;
    }

    public static class EmitDownloadEvents {
        private final IDownloadListener.Access access;
        private final IDownloadListener listener;

        public EmitDownloadEvents(IDownloadListener.Access access, IDownloadListener listener) {
            assert (access != null);
            assert (listener != null);
            this.access = access;
            this.listener = listener;
        }

        public IDownloadListener.Access getAccess() {
            return this.access;
        }

        public IDownloadListener getFire() {
            return this.listener;
        }
    }
}

