/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.downloads.DownloadContextThreadLocalInheritedAndGlobal;
import com.ibm.cic.common.core.internal.downloads.Messages;
import com.ibm.cic.common.downloads.AbstractDownloadListener;
import com.ibm.cic.common.downloads.DownloadEvents;
import com.ibm.cic.common.downloads.DownloadHandlerRequest;
import com.ibm.cic.common.downloads.IDownloadListener;
import com.ibm.cic.common.downloads.SocketEvents;
import com.ibm.cic.common.logging.Level;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.logging.SupplementaryLoggerRunIfLastManager;
import java.io.FileNotFoundException;

public class DownloadLiveSupplementaryReporter {
    private IDownloadListener downloadListener;
    private SupplementaryLoggerRunIfLastManager.SupplementaryLoggerRunIfLastContext slogCheckPoint = SupplementaryLoggerRunIfLastManager.INSTANCE.openRunIfLastContext("DownloadExceptions");
    private SocketEvents.SocketListener socketListener;

    public DownloadLiveSupplementaryReporter() {
        if (this.slogCheckPoint.hasCreatedLog()) {
            this.downloadListener = new AbstractDownloadListener(){

                @Override
                public void exit(DownloadHandlerRequest request, Object returns) {
                    if (returns instanceof Throwable) {
                        if (returns instanceof FileNotFoundException) {
                            return;
                        }
                        String strRequest = request.getLocalizedRequest();
                        DownloadLiveSupplementaryReporter.this.getLog().error((Throwable)returns, Messages.DownloadLiveSupplementaryReporter_reportException, strRequest, returns);
                    }
                }
            };
            this.socketListener = new SocketEvents.SocketListener(){

                @Override
                public void onSocketConnectFailed(SocketEvents.SocketToConnect stc, Throwable t) {
                    DownloadLiveSupplementaryReporter.this.getLog().error(t, Messages.DownloadLiveSupplementaryReporter_reportSocketConnectException, stc, t);
                }

                @Override
                public void onFailedSocketEvent(SocketEvents.IEventWithSocket event, Throwable e) {
                    DownloadLiveSupplementaryReporter.this.getLog().error(e, Messages.DownloadLiveSupplementaryReporter_reportSocketException, event.getEventTypeName(), event.getSocket(), e);
                }
            };
            SocketEvents.INSTANCE.addSocketListener(this.socketListener);
            this.getLog().info(Messages.DownloadLiveSupplementaryReporter_logHeadExplanation);
            DownloadEvents.getDownloadEvents(DownloadContextThreadLocalInheritedAndGlobal.getThreadContext()).addListener(this.downloadListener);
        }
    }

    public void checkLastSupplementaryLogger(final Logger mainLog, final boolean keepIfUsed, final String explanationMsg) {
        this.slogCheckPoint.runIfLastSupplementaryLogger(new SupplementaryLoggerRunIfLastManager.ISupplementaryLoggerRunnable(){

            @Override
            public void run(Logger.SupplementaryLogger slog) {
                if (keepIfUsed && SupplementaryLoggerRunIfLastManager.SupplementaryLoggerRunIfLastContext.checkUsed(slog)) {
                    if (explanationMsg != null) {
                        slog.info(explanationMsg);
                    }
                    mainLog.log(Level.WARNING, slog.getPath(), 0, Messages.DownloadLiveSupplementaryReporter_link$uid, null, Messages.DownloadLiveSupplementaryReporter_link, slog.getPath());
                    slog.close();
                } else {
                    slog.delete();
                }
                SocketEvents.INSTANCE.removeSocketListener(DownloadLiveSupplementaryReporter.this.socketListener);
                DownloadEvents.getDownloadEvents(DownloadContextThreadLocalInheritedAndGlobal.getThreadContext()).removeListener(DownloadLiveSupplementaryReporter.this.downloadListener);
            }
        });
    }

    private Logger getLog() {
        return this.slogCheckPoint.getSlog();
    }
}

