/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.downloads.DownloadException;
import com.ibm.cic.common.downloads.DownloadPrematureEOFException;
import com.ibm.cic.common.downloads.DownloadProtocolException;
import com.ibm.cic.common.downloads.DownloadRangeNotSatisfiableException;
import com.ibm.cic.common.downloads.DownloadRetryLevel;
import com.ibm.cic.common.downloads.DownloadStatusException;
import java.io.FileNotFoundException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;

public class DownloadHandlerDefaultRetryLevel {
    private static final String SOCKS_SERVER_GENERAL_FAILURE = "socks server general failure";
    private static final String RESET_CONNECTION = "reset";
    private static final String POSSIBLE_INVALID_ADDRESS = "connect:could be due to invalid address";
    private static final String SSL_PEER_SHUT_DOWN = "ssl peer shut down";

    public static DownloadRetryLevel retryLevel(Exception exception) {
        assert (exception != null);
        if (exception instanceof InterruptedIOException) {
            return DownloadRetryLevel.RETRY_LEVEL_NETWORK_TIMEOUT_OR_DROPPED;
        }
        if (exception instanceof DownloadException) {
            if (exception instanceof DownloadPrematureEOFException) {
                return DownloadRetryLevel.RETRY_LEVEL_NETWORK_STRESSED;
            }
            if (exception instanceof DownloadRangeNotSatisfiableException) {
                return DownloadRetryLevel.RETRY_LEVEL_REQUEST_UNSATISFIABLE;
            }
            if (exception instanceof DownloadProtocolException) {
                return DownloadRetryLevel.RETRY_LEVEL_RESPONSE_UNEXPECTED_STATUS;
            }
            if (exception instanceof DownloadStatusException) {
                return DownloadRetryLevel.RETRY_LEVEL_RESPONSE_UNEXPECTED_STATUS;
            }
            return DownloadRetryLevel.RETRY_LEVEL_BUG;
        }
        if (exception instanceof IllegalArgumentException) {
            return DownloadRetryLevel.RETRY_LEVEL_INVALID_REQUEST;
        }
        if (exception instanceof URISyntaxException) {
            return DownloadRetryLevel.RETRY_LEVEL_INVALID_REQUEST;
        }
        if (exception instanceof MalformedURLException) {
            return DownloadRetryLevel.RETRY_LEVEL_INVALID_REQUEST;
        }
        if (exception instanceof RuntimeException) {
            return DownloadRetryLevel.RETRY_LEVEL_BUG;
        }
        if (exception instanceof UnknownHostException) {
            return DownloadRetryLevel.RETRY_LEVEL_RETRY_FAIL_UNLESS_NETWORK_CHANGES;
        }
        if (exception instanceof FileNotFoundException) {
            return DownloadRetryLevel.RETRY_LEVEL_NON_NETWORK_EXCEPTION;
        }
        if (exception instanceof SocketException) {
            return DownloadHandlerDefaultRetryLevel.retryCodeSocketException((SocketException)exception);
        }
        if (exception instanceof SSLException) {
            return DownloadHandlerDefaultRetryLevel.retryCodeSSLException((SSLException)exception);
        }
        return DownloadRetryLevel.RETRY_LEVEL_NON_NETWORK_EXCEPTION;
    }

    private static DownloadRetryLevel retryCodeSocketException(SocketException exception) {
        if (exception instanceof BindException) {
            return DownloadRetryLevel.RETRY_LEVEL_NETWORK_STRESSED;
        }
        if (exception instanceof NoRouteToHostException) {
            return DownloadRetryLevel.RETRY_LEVEL_RETRY_FAIL_UNLESS_NETWORK_CHANGES;
        }
        if (exception instanceof PortUnreachableException) {
            return DownloadRetryLevel.RETRY_LEVEL_RETRY_FAIL_UNLESS_NETWORK_CHANGES;
        }
        if (exception instanceof ConnectException) {
            return DownloadRetryLevel.RETRY_LEVEL_CONNECT_REFUSED;
        }
        String msg = exception.getMessage().toLowerCase();
        if (msg.indexOf(RESET_CONNECTION) != -1) {
            return DownloadRetryLevel.RETRY_LEVEL_NETWORK_STRESSED;
        }
        if (msg.indexOf(SOCKS_SERVER_GENERAL_FAILURE) != -1) {
            return DownloadRetryLevel.RETRY_LEVEL_SERVER_ERROR;
        }
        if (msg.indexOf(POSSIBLE_INVALID_ADDRESS) != -1) {
            return DownloadRetryLevel.RETRY_LEVEL_RETRY_FAIL_UNLESS_NETWORK_CHANGES;
        }
        return DownloadRetryLevel.RETRY_LEVEL_NETWORK_STRESSED;
    }

    private static DownloadRetryLevel retryCodeSSLException(SSLException exception) {
        if (DownloadHandlerDefaultRetryLevel.isSSLSecurityException(exception)) {
            return DownloadRetryLevel.RETRY_LEVEL_REQUEST_UNSATISFIABLE;
        }
        return DownloadRetryLevel.RETRY_LEVEL_NETWORK_STRESSED;
    }

    public static boolean isSSLSecurityException(SSLException exception) {
        if (exception instanceof SSLHandshakeException || exception instanceof SSLKeyException || exception instanceof SSLPeerUnverifiedException || exception instanceof SSLProtocolException) {
            return true;
        }
        String msg = exception.getMessage().toLowerCase();
        return msg.indexOf(SSL_PEER_SHUT_DOWN) == -1;
    }
}

