/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.downloads.AuthenticationSchemeUtil;
import com.ibm.cic.common.downloads.CredentialInfo;
import com.ibm.cic.common.downloads.CredentialRequested;
import com.ibm.cic.common.downloads.ICredentialValidator;
import com.ibm.cic.common.downloads.UrlUserInfoUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CredentialPromptConversation {
    private static final String DIALOG_MESSAGE_TOKEN = "@DLG@";
    private SimpleTextBox uidText;
    private SimpleTextBox pwdText;
    private SimpleTextBox domainText;
    private SimpleCheckBox persist;
    private SimpleTextBox messageLink;
    private final ICredentialValidator validator;
    private String connectMessage;
    private String dialogMessage;
    private IStatus status;
    private final CredentialRequested requested;
    private final CredentialInfo previousCredentialInfo;
    private CredentialInfo credentialInfo;

    public CredentialPromptConversation(ICredentialValidator validator, String connectMessage, CredentialRequested requested, CredentialInfo previous) {
        this.validator = validator;
        this.requested = requested;
        this.previousCredentialInfo = previous != null && previous.isSomething() ? previous : null;
        this.setupMessages(connectMessage);
    }

    private void setupMessages(String message) {
        int index = message.indexOf(DIALOG_MESSAGE_TOKEN);
        if (index == -1) {
            this.connectMessage = message;
        } else {
            this.connectMessage = message.substring(0, index);
            if (message.length() > this.connectMessage.length() + DIALOG_MESSAGE_TOKEN.length()) {
                this.dialogMessage = message.substring(index + DIALOG_MESSAGE_TOKEN.length());
            }
        }
    }

    public String getConnectMessage() {
        return this.connectMessage;
    }

    public SimpleCheckBox getPersist() {
        return this.persist;
    }

    public void startConversation() {
        this.uidText = new SimpleTextBox();
        String uidDefault = null;
        String pwDefault = null;
        if (this.previousCredentialInfo != null) {
            uidDefault = this.previousCredentialInfo.getUid();
        } else if (AuthenticationSchemeUtil.isFTPScheme(this.requested.getScheme())) {
            String[] userInfo = UrlUserInfoUtil.getUsernameAndPassword(this.requested.getRealm());
            if (userInfo != null) {
                assert (userInfo[0] != null);
                uidDefault = userInfo[0];
                pwDefault = userInfo[1];
            } else {
                uidDefault = "anonymous";
            }
            if (uidDefault != null) {
                this.uidText.setText(uidDefault);
            }
        }
        this.pwdText = new SimpleTextBox();
        if (pwDefault != null) {
            this.pwdText.setText(pwDefault);
        }
        if (this.needsDomain()) {
            this.domainText = new SimpleTextBox();
        }
        this.persist = new SimpleCheckBox();
        if (this.previousCredentialInfo != null) {
            this.persist.setSelection(this.previousCredentialInfo.isPersist());
        }
        if (this.dialogMessage != null) {
            this.messageLink = new SimpleTextBox();
            this.messageLink.setText(this.dialogMessage);
        }
        if (uidDefault != null) {
            this.uidText.setText(uidDefault);
            if (pwDefault != null) {
                this.pwdText.setText(pwDefault);
            }
        }
    }

    public boolean needsDomain() {
        return this.requested != null && AuthenticationSchemeUtil.isNTLMScheme(this.requested.getScheme());
    }

    public SimpleTextBox getDomainText() {
        return this.domainText;
    }

    public SimpleTextBox getLinksText() {
        return this.messageLink;
    }

    public SimpleTextBox getUidText() {
        return this.uidText;
    }

    public SimpleTextBox getPwdText() {
        return this.pwdText;
    }

    public IStatus ok() {
        String uid = this.uidText.getText().trim();
        String pwd = this.pwdText.getText().trim();
        CredentialInfo tempCredentialInfo = new CredentialInfo();
        tempCredentialInfo.setUid(uid);
        tempCredentialInfo.setPwd(pwd);
        if (this.needsDomain()) {
            String domain = this.domainText.getText().trim();
            tempCredentialInfo.setDomain(domain);
        }
        tempCredentialInfo.setPersist(this.persist.getSelection());
        this.status = this.validator.validate(tempCredentialInfo);
        if (!this.status.matches(4)) {
            this.credentialInfo = tempCredentialInfo;
        }
        return this.status;
    }

    public void cancel() {
        this.status = Status.CANCEL_STATUS;
    }

    public CredentialInfo getCredentialInfo() {
        return this.credentialInfo;
    }

    public IStatus getOkStatus() {
        return this.status;
    }

    public static class SimpleCheckBox {
        private boolean selected;

        public boolean getSelection() {
            return this.selected;
        }

        public void setSelection(boolean checked) {
            this.selected = checked;
        }

        public String toString() {
            return this.getSelection() ? "[x]" : "[ ]";
        }
    }

    public static class SimpleTextBox {
        private String text = "";

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public boolean isNonEmptyText() {
            return this.text.length() > 0;
        }

        public String toString() {
            return this.getText();
        }
    }
}

