/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.volrepo;

import com.ibm.cic.common.core.artifactrepo.impl.ArtifactTableOfContents;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactTocModel;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.volrepo.VolumeRepository;
import com.ibm.cic.common.downloads.ContentInfo;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadSession;
import com.ibm.cic.common.logging.Logger;
import java.io.IOException;
import java.net.URL;
import java.util.SortedMap;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.xml.sax.SAXException;

public class VolumesArtifactTableOfContents {
    private static final String ATTR_DISK = "disk";
    private static final String ATTR_DISK_COUNT = "diskCount";
    private static final String[] EXTRA_ATTRIBUTE_NAMES = new String[]{"disk", "diskCount"};
    private static final SetParameters SET_PARAMS_SELF_DIGEST_ENABLED = new SetParameters(true);
    private static final SetParameters SET_PARAMS_SELF_DIGEST_DISABLED = new SetParameters(false);

    public static SetParameters getVtocParameters(boolean useSelfDigest) {
        return useSelfDigest ? SET_PARAMS_SELF_DIGEST_ENABLED : SET_PARAMS_SELF_DIGEST_DISABLED;
    }

    private static VolumeArtifact wrapWithExtraInfo(IArtifact artifact) {
        if (artifact instanceof VolumeArtifact) {
            VolumeArtifact va = (VolumeArtifact)artifact;
            return va;
        }
        return new VolumeArtifact(artifact);
    }

    public static VolumeArtifact setArtifactDisk(IArtifact artifact, int index) {
        VolumeArtifact va = VolumesArtifactTableOfContents.wrapWithExtraInfo(artifact);
        va.getExtraInfo().getAttributeMap().put(ATTR_DISK, Integer.toString(index));
        return va;
    }

    public static VolumeArtifact setArtifactDiskCount(IArtifact artifact, int count) {
        VolumeArtifact va = VolumesArtifactTableOfContents.wrapWithExtraInfo(artifact);
        va.getExtraInfo().getAttributeMap().put(ATTR_DISK_COUNT, Integer.toString(count));
        return va;
    }

    public static void addOrUpdateTocArtifacts(SetParameters params, IPath contentFolderPath, IArtifact[] artifacts, ArtifactTableOfContents.IOnAtocSaved onSaved) throws CoreException, IOException {
        ArtifactTableOfContents.addOrUpdateTocArtifacts(null, params, contentFolderPath, artifacts, onSaved, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void removeTocEntries(SetParameters params, IPath contentFolderPath, IArtifact[] artifactsToRemove, ArtifactTableOfContents.IOnAtocSaved onSaved) throws Exception {
        ArtifactTableOfContents.removeTocEntries(null, params, contentFolderPath, artifactsToRemove, onSaved, (IProgressMonitor)new NullProgressMonitor());
    }

    public static ArtifactTableOfContents.TocHolder getToc(SetParameters params, IDownloadSession session, IPath contentFolderPath, IContentInfo contentInfo, IProgressMonitor monitor) throws IOException, CoreException {
        try {
            return ArtifactTableOfContents.getToc(session, (ArtifactTableOfContents.Parameters)params, contentFolderPath, contentInfo, monitor);
        }
        catch (ParserConfigurationException e) {
            Logger.getGlobalLogger().error(e, e.getLocalizedMessage(), new Object[0]);
            throw new IOException(e.toString());
        }
        catch (SAXException e) {
            Logger.getGlobalLogger().error(e, e.getLocalizedMessage(), new Object[0]);
            throw new IOException(e.toString());
        }
    }

    public static ArtifactTableOfContents.TocHolder getToc(SetParameters params, IDownloadSession session, URL contentFolderUrl, IContentInfo contentInfo, IProgressMonitor monitor) throws IOException, CoreException {
        return ArtifactTableOfContents.getToc(session, (ArtifactTableOfContents.Parameters)params, contentFolderUrl, contentInfo, monitor);
    }

    public static DiskInfo getDiskInfo(IDownloadSession session, ArtifactTableOfContents.TocHolder tocHolder, IArtifact iartifact, IProgressMonitor monitor) throws IOException, CoreException {
        ArtifactTocModel.Artifact artifact = tocHolder.getArtifact(session, iartifact.getKey(), monitor);
        if (artifact == null) {
            return null;
        }
        return VolumesArtifactTableOfContents.getDiskInfo(artifact);
    }

    public static DiskInfo getDiskInfo(ArtifactTocModel.Artifact artifact) {
        ArtifactTableOfContents.ExtraInfo extraInfo = (ArtifactTableOfContents.ExtraInfo)artifact.getExtraInfo();
        if (extraInfo == null) {
            return null;
        }
        SortedMap<String, String> attrMap = extraInfo.getAttributeMap();
        if (attrMap == null) {
            return null;
        }
        String strDisk = (String)extraInfo.getAttributeMap().get(ATTR_DISK);
        String strDiskCount = (String)extraInfo.getAttributeMap().get(ATTR_DISK_COUNT);
        int disk = -1;
        int diskCount = 0;
        if (strDisk == null) {
            return null;
        }
        try {
            disk = Integer.parseInt(strDisk);
        }
        catch (NumberFormatException e) {
            VolumeRepository.log.error(e);
            return null;
        }
        if (strDiskCount != null) {
            try {
                diskCount = Integer.parseInt(strDiskCount);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return new DiskInfo(disk, diskCount);
    }

    public static class DiskInfo {
        private final int disk;
        private final int diskCount;

        public DiskInfo(int disk, int diskCount) {
            this.disk = disk;
            this.diskCount = diskCount;
        }

        public int getDiskNum() {
            return this.disk;
        }

        public int getDiskCount() {
            return this.diskCount;
        }
    }

    public static class SetParameters
    extends ArtifactTableOfContents.Parameters {
        SetParameters(boolean supportDigests) {
            super("datoc.xml", "toc/", null, false, false, false, false, EXTRA_ATTRIBUTE_NAMES, supportDigests);
        }
    }

    public static class VolumeArtifact
    extends ArtifactTableOfContents.ArtifactWithExtraTocInfo {
        public VolumeArtifact(IArtifact artifact) {
            super(artifact);
        }

        @Override
        public IContentInfo getContentInfo() {
            return ContentInfo.EMPTY_CONTENT_INFO;
        }
    }
}

