/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.utils.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FileReplicator {
    private final File replicaDir;
    private final Map replicas;
    private static Set objRefs = null;

    public FileReplicator(File destDir) {
        this.replicaDir = destDir;
        this.replicas = new HashMap();
    }

    public File getReplica(File file) throws IOException {
        long lastModified;
        if (file.isDirectory()) {
            return null;
        }
        String filePath = FileUtil.getCanonicalPath(file);
        File replica = (File)this.replicas.get(filePath);
        if (replica != null && replica.exists() && (lastModified = file.lastModified()) != 0L && lastModified == replica.lastModified()) {
            return replica;
        }
        if (!this.replicaDir.exists()) {
            this.replicaDir.mkdirs();
        }
        File tmpFile = FileUtil.createTempFile(file.getName(), ".tmp", this.replicaDir);
        FileUtil.copyFile(file, tmpFile);
        tmpFile.setLastModified(file.lastModified());
        this.replicas.put(filePath, tmpFile);
        return tmpFile;
    }

    public void cleanAllReplicas() {
        File[] files;
        if (this.replicaDir.exists() && (files = this.replicaDir.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                FileUtil.delete(file);
                ++n2;
            }
        }
        this.replicas.clear();
    }

    @Deprecated
    public static void addReference(Object object) {
        if (objRefs == null) {
            objRefs = new HashSet();
        }
        objRefs.add(object);
    }

    @Deprecated
    public static void clearReferences() {
        objRefs = null;
    }
}

