/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.core.utils.Messages;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.SharedFileLock;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.logging.LogManager;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;

public class EclipseUtil {
    private static final Logger log = Logger.getLogger(EclipseUtil.class);
    private static final String OSGI_ID = "org.eclipse.osgi";
    private static final String CORE_RUNTIME_ID = "org.eclipse.core.runtime";
    private static final String MANAGER_PATH = "/.manager";
    private static final String INSTANCE_EXT = ".instance";

    public static boolean isEclipseRunning(File configurationLocation) {
        List<File> match = EclipseUtil.getInstanceFiles(configurationLocation);
        for (File file : match) {
            SharedFileLock sfl = new SharedFileLock(file);
            IStatus status = sfl.acquire();
            if (status.isOK()) {
                sfl.release();
                continue;
            }
            return true;
        }
        return false;
    }

    public static File getCurrentEclipseConfiguration() {
        File return_value = null;
        String configurationLocation = System.getProperty("osgi.sharedConfiguration.area");
        if (configurationLocation == null) {
            configurationLocation = System.getProperty("osgi.configuration.area");
        }
        if (configurationLocation != null) {
            if (configurationLocation.startsWith("file:")) {
                configurationLocation = configurationLocation.substring("file".length() + 1);
            }
            return_value = new File(configurationLocation);
            try {
                return_value = return_value.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return return_value;
    }

    public static File getCurrentEclipseWorkspace() {
        File return_value = null;
        String workspaceLocation = System.getProperty("osgi.instance.area");
        if (workspaceLocation != null) {
            if (workspaceLocation.startsWith("file:")) {
                workspaceLocation = workspaceLocation.substring("file".length() + 1);
            }
            return_value = new File(workspaceLocation);
            try {
                return_value = return_value.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return return_value;
    }

    public static boolean isEclipseConfigOsgiDirWriteable() {
        File osgiDir = new File(EclipseUtil.getCurrentEclipseConfiguration(), OSGI_ID);
        return osgiDir.exists() && osgiDir.canWrite();
    }

    public static void shutdownFramework() {
        EclipseUtil.shutdownConsoleOutput();
        new Thread(){

            @Override
            public void run() {
                try {
                    BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
                    if (bundleContext != null) {
                        EclipseUtil.stopBundle("org.eclipse.equinox.http.jetty");
                        EclipseUtil.stopBundle("org.eclipse.rap.ui.workbench");
                        bundleContext.getBundle(0L).stop(1);
                    }
                }
                catch (BundleException ex) {
                    log.error(NLS.bind(Messages.EclipseUtil_shutdownProblem, (Object)ex.getMessage()), new Object[]{ex});
                }
            }
        }.start();
    }

    private static void stopBundle(String id) throws BundleException {
        Bundle bundle = Platform.getBundle((String)id);
        if (bundle != null) {
            bundle.stop(1);
        } else {
            log.warning(NLS.bind(Messages.EclipseUtil_bundleNotFound, (Object)id));
        }
    }

    private static void shutdownConsoleOutput() {
        if (!log.isDebugLoggable()) {
            PrintStream nullPrintStream = Encodings.DEFAULT.toPrintStream(new Util.NullOutputStream());
            System.setErr(nullPrintStream);
            System.setOut(nullPrintStream);
            LogManager.closeAll();
        }
    }

    private static List<File> getInstanceFiles(File configurationLocation) {
        String[] plugins;
        ArrayList<File> result = new ArrayList<File>();
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(EclipseUtil.INSTANCE_EXT);
            }
        };
        String[] stringArray = plugins = new String[]{OSGI_ID, CORE_RUNTIME_ID};
        int n = plugins.length;
        int n2 = 0;
        while (n2 < n) {
            String plugin = stringArray[n2];
            File manager = new File(configurationLocation, String.valueOf(plugin) + MANAGER_PATH);
            File[] match = manager.listFiles(filter);
            if (match != null) {
                File[] fileArray = match;
                int n3 = match.length;
                int n4 = 0;
                while (n4 < n3) {
                    File file = fileArray[n4];
                    result.add(file);
                    ++n4;
                }
            }
            ++n2;
        }
        return result;
    }
}

