/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.sharedUI;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.sharedUI.Messages;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.StatusFormatter;
import com.ibm.cic.common.logging.ExceptionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;

public class CommonSharedUIUtils {
    private static final String DISPLAY_INFO_UNIQUE_FAKE_PLUGINID = String.valueOf(ComIbmCicCommonCorePlugin.getPluginId()) + "/SharedUIRepoUtils";
    private static final String AMPERSAND = "&";
    private static final String COLON = ":";

    public static boolean isRepositoryOpenerOKMessage(IStatus status) {
        return status.isOK() && status.getPlugin().equals(DISPLAY_INFO_UNIQUE_FAKE_PLUGINID) && status.getCode() == 1;
    }

    public static boolean isRepositoryStatusMessage(IStatus status) {
        return status.getPlugin().equals(DISPLAY_INFO_UNIQUE_FAKE_PLUGINID);
    }

    public static IStatus constructRepositoryStatus(Map repLocationMsgMap) {
        boolean serviceRep = false;
        String repMsg = CommonSharedUIUtils.constructRepositoryMessages(repLocationMsgMap, serviceRep);
        if (repMsg.length() > 0) {
            if (CommonSharedUIUtils.repositoryMessageContainWarning(repLocationMsgMap)) {
                return new Status(2, DISPLAY_INFO_UNIQUE_FAKE_PLUGINID, repMsg);
            }
            return new Status(0, DISPLAY_INFO_UNIQUE_FAKE_PLUGINID, 1, repMsg, null);
        }
        return Status.OK_STATUS;
    }

    public static String constructRepositoryMessages(Map repLocationMsgMap, boolean serviceRep) {
        StringBuffer buffer = new StringBuffer();
        if (!repLocationMsgMap.isEmpty()) {
            if (!serviceRep) {
                buffer.append(Messages.RepositorySectionTitle_repMsg);
                buffer.append("\n\n");
            } else {
                buffer.append(Messages.RepositorySectionTitle_serviceRepMsg);
                buffer.append("\n\n");
            }
            Set entries = repLocationMsgMap.entrySet();
            for (Map.Entry entry : entries) {
                String repLocation = (String)entry.getKey();
                List statusList = (List)entry.getValue();
                StringBuffer repMsg = new StringBuffer();
                int i = 0;
                while (i < statusList.size()) {
                    repMsg.append(" ");
                    IStatus status = (IStatus)statusList.get(i);
                    if (status.getSeverity() == 4) {
                        repMsg.append(NLS.bind((String)Messages.RepositorySectionMsgType_Error, (Object)status.getMessage()));
                    } else if (status.getSeverity() == 2) {
                        repMsg.append(NLS.bind((String)Messages.RepositorySectionMsgType_Warning, (Object)status.getMessage()));
                    } else {
                        repMsg.append(NLS.bind((String)Messages.RepositorySectionMsgType_Info, (Object)status.getMessage()));
                    }
                    repMsg.append("\n");
                    ++i;
                }
                if (!repLocation.startsWith("-")) {
                    buffer.append("-");
                }
                buffer.append(repLocation);
                buffer.append("\n");
                buffer.append(repMsg.toString());
            }
        }
        return buffer.toString();
    }

    public static void generateRepositoryStatusList(IRepositoryInfo repInfo, Map repLocationStatusListMap) {
        if (repInfo != null) {
            CicMultiStatus subStatuses;
            ArrayList<IStatus> statusList = new ArrayList<IStatus>();
            IStatus repStatus = repInfo.getRepositoryReportedStatus();
            if (repStatus != null && repStatus.getMessage().trim().length() > 0) {
                statusList.add(repStatus);
            }
            if ((subStatuses = (CicMultiStatus)repInfo.getProperty("RepositoryReportedStatuses")) != null) {
                IStatus[] childrenStatus;
                IStatus[] iStatusArray = childrenStatus = subStatuses.getChildren();
                int n = childrenStatus.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus childrenStatu = iStatusArray[n2];
                    statusList.add(childrenStatu);
                    ++n2;
                }
            }
            if (!statusList.isEmpty()) {
                repLocationStatusListMap.put(repInfo.getLocationStr(), statusList);
            }
        }
    }

    public static boolean repositoryMessageContainWarning(Map repLocationMsgMap) {
        if (!repLocationMsgMap.isEmpty()) {
            Set entries = repLocationMsgMap.entrySet();
            for (Map.Entry entry : entries) {
                List statusList = (List)entry.getValue();
                int i = 0;
                while (i < statusList.size()) {
                    IStatus status = (IStatus)statusList.get(i);
                    if (status.getSeverity() == 2 || status.getSeverity() == 4) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    public static String removeAmpersand(String swtLabel) {
        Pattern pattern = Pattern.compile("\\&(.)");
        return pattern.matcher(swtLabel).replaceAll("$1");
    }

    public static String extractCommandKey(String label) {
        if (label == null || label.trim().length() == 0) {
            return "";
        }
        int index = label.indexOf(AMPERSAND);
        if (index == -1 || index > label.length() - 2) {
            return "";
        }
        String commandKey = label.substring(index + 1, index + 2);
        if (commandKey.equals(AMPERSAND)) {
            if (index == label.length() - 2) {
                return "";
            }
            return CommonSharedUIUtils.extractCommandKey(label.substring(index + 2));
        }
        return commandKey.toUpperCase();
    }

    public static String removeEndingColon(String label) {
        if (label.endsWith(COLON)) {
            label = label.substring(0, label.length() - 1);
        }
        return label;
    }

    public static boolean shouldShowViewDetails(IStatus status) {
        IStatus[] children;
        if (status.isMultiStatus() && (children = status.getChildren()) != null && children.length > 0) {
            return true;
        }
        return CommonSharedUIUtils.hasUID(status);
    }

    public static boolean hasUID(IStatus status) {
        return CommonSharedUIUtils.hasUID(status, false);
    }

    public static boolean hasUID(IStatus status, boolean checkChildren) {
        CicMultiStatus multiStatus;
        IStatus[] children;
        ICicStatus cicStatus;
        String uid;
        if (status instanceof ICicStatus && (uid = (cicStatus = (ICicStatus)status).getUid()) != null && uid.length() > 0) {
            return true;
        }
        if (checkChildren && status.isMultiStatus() && status instanceof CicMultiStatus && (children = (multiStatus = (CicMultiStatus)status).getChildren()) != null && children.length > 0) {
            IStatus[] iStatusArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus element = iStatusArray[n2];
                if (CommonSharedUIUtils.hasUID(element, true)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static void populateDetailArea(IStatus status, OutputFormatter detailTextStringBuffer) {
        ICicStatus cicStatus;
        String uid;
        boolean displayUID = false;
        if (status instanceof ICicStatus && (uid = (cicStatus = (ICicStatus)status).getUid()) != null && uid.length() > 0) {
            String userAction;
            displayUID = true;
            detailTextStringBuffer.appendNTnl(NLS.bind((String)com.ibm.cic.common.core.internal.Messages.ErrorDlg_MessageID, (Object)uid));
            String explanation = cicStatus.getExplanation();
            if (explanation != null && explanation.length() > 0) {
                detailTextStringBuffer.nl();
                detailTextStringBuffer.appendNTnl(NLS.bind((String)com.ibm.cic.common.core.internal.Messages.ErrorDlg_Explanation, (Object)explanation));
            }
            if ((userAction = cicStatus.getUserAction()) != null && userAction.length() > 0) {
                detailTextStringBuffer.nl();
                detailTextStringBuffer.appendNTnl(NLS.bind((String)com.ibm.cic.common.core.internal.Messages.ErrorDlg_UserAction, (Object)userAction));
            }
            detailTextStringBuffer.nl();
        }
        if (displayUID) {
            detailTextStringBuffer.incTab();
        }
        new StatusFormatter(detailTextStringBuffer).formatChildren(status);
        if (displayUID) {
            detailTextStringBuffer.decTab();
        }
        detailTextStringBuffer.removeTrailingSpace();
    }

    public static boolean offeringOrFixMatches(IOfferingOrFix offeringOrFix, String id, String versionRange) {
        if (offeringOrFix == null || !offeringOrFix.getIdentity().getId().equals(id)) {
            return false;
        }
        try {
            return new VersionRange(versionRange).isIncluded(offeringOrFix.getVersion());
        }
        catch (IllegalArgumentException e) {
            ExceptionUtil.log.warning(e);
            return false;
        }
    }
}

