/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository.digest;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.internal.downloads.FileContentInfo;
import com.ibm.cic.common.core.model.Information;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.internal.DigestAttributes;
import com.ibm.cic.common.core.repository.CicFileLocation;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.digest.RepositoryDigest;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestBaseOfferingData;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestDictionary;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestFixData;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestOfferingData;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestRepositoryData;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestToc;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestTocEntry;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.core.utils.MetaInfo;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.XMLParser;
import com.ibm.cic.common.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class RepositoryDigestParser
extends XMLParser {
    private static final Logger log = Logger.getLogger(RepositoryDigestParser.class);
    private static final int IGNORED_ELEMENT_STATE = 0;
    private static final int NO_CONTENT_STATE = 1;
    protected static final int INITIAL_STATE = 2;
    protected static final int REPOSITORY_DIGEST_STATE = 3;
    private static final int REPOSITORY_STATE = 4;
    private static final int OFFERING_STATE = 5;
    private static final int FIX_STATE = 6;
    private static final int BASE_OFFERING_STATE = 7;
    private static final int INFORMATION_STATE = 8;
    private static final int DICTIONARY_STATE = 9;
    private static final int FILE_STATE = 10;
    private static final int TOC_STATE = 11;
    protected static final String[] STATE_NAMES = new String[]{"IGNORED", "NO CONTENT", "INITIAL", "repositoryDigest", "repository", "offering", "fix", "baseOffering", "information", "dictionary", "file", "toc"};
    protected final RepositoryDigest m_repositoryDigest;
    private String m_inputStreamUrl;
    private final ICicLocation m_remotePath;

    public RepositoryDigestParser(BundleContext context, RepositoryDigest repositoryDigest, ICicLocation remotePath) {
        super(context, ComIbmCicCommonCorePlugin.getPluginId());
        this.stateStack = new XMLParser.StateStack(STATE_NAMES);
        this.m_repositoryDigest = repositoryDigest;
        this.m_remotePath = remotePath;
    }

    @Override
    protected String getErrorMessage() {
        return Messages.Repo_Error_Parsing_Repository_Digest_File;
    }

    @Override
    protected Object getRootObject() {
        return null;
    }

    @Override
    protected String processCharacters(String trimmedChars) {
        switch (this.stateStack.peekState()) {
            case 8: {
                Information info = (Information)this.stateStack.peekObject();
                info.setDescription(trimmedChars);
                break;
            }
        }
        return trimmedChars;
    }

    void parse(InputSource inputSource) throws IOException {
        this.m_inputStreamUrl = inputSource.getSystemId();
        this.m_inputStreamUrl = this.m_inputStreamUrl == null ? "" : this.m_inputStreamUrl;
        try {
            try {
                this.getParser().parse(inputSource, (DefaultHandler)this);
            }
            catch (SAXException e) {
                throw new IOException(e.getMessage());
            }
            catch (ParserConfigurationException e) {
                throw new IOException(e.getMessage());
            }
        }
        finally {
            InputStream in = inputSource.getByteStream();
            if (in != null) {
                in.close();
            }
        }
    }

    @Override
    public void startDocument() {
        this.stateStack.clear();
        this.stateStack.push(2, null);
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        Version version;
        if ("repositoryDigest".equals(target) && !RepositoryDigest.INSTALL_REPOSITORY_DIGEST_VERSION_TOLERANCE.isIncluded(version = MetaInfo.extractVersion(data))) {
            throw new SAXParseException(NLS.bind(Messages.TocParser_incompatible_version, "repository.xml", version, RepositoryDigest.INSTALL_REPOSITORY_DIGEST_VERSION_TOLERANCE), this.locator);
        }
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes attributes) throws SAXException {
        this.trace(name, attributes);
        switch (this.stateStack.peekState()) {
            case 0: {
                this.stateStack.push(0, "error: " + name);
                break;
            }
            case 2: {
                this.handleInitialState(name, attributes);
                break;
            }
            case 3: {
                this.handleRepositoryDigestState(name, attributes);
                break;
            }
            case 4: {
                this.handleRepositoryState(name, attributes);
                break;
            }
            case 5: {
                this.handleOfferingState(name, attributes);
                break;
            }
            case 6: {
                this.handleFixState(name, attributes);
                break;
            }
            case 8: {
                this.handleInformationState(name, attributes);
                break;
            }
            case 9: {
                this.handleDictionaryState(name, attributes);
                break;
            }
            case 10: {
                this.handleFileState(name, attributes);
                break;
            }
            case 11: {
                this.handleTocState(name, attributes);
                break;
            }
            default: {
                throw new XMLParser.BadStateError(this);
            }
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        this.trace(name, null);
        int state = this.stateStack.peekState();
        switch (state) {
            case 8: {
                this.finishCharacters();
                break;
            }
            case 4: {
                this.endRepositoryState();
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            default: {
                throw new XMLParser.BadStateError(this);
            }
        }
        if (state != 2) {
            this.stateStack.pop();
        }
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    private void handleInitialState(String element, Attributes attributes) throws SAXException {
        if (element.equals("repositoryDigest")) {
            this.stateStack.push(3, null);
        } else if (element.equals("toc")) {
            throw new SAXException("old file format");
        }
    }

    private void handleRepositoryDigestState(String element, Attributes attributes) {
        if (element.equals("repository")) {
            String[] values = this.parseAttributes(element, attributes, new String[0], new String[]{"name", "location", "useContentData"});
            RepositoryDigestRepositoryData rdd = this.m_repositoryDigest.getThisRepositoryData();
            if (values[2] != null) {
                rdd.setUseContentData(Boolean.getBoolean(values[2]));
            } else {
                rdd.setUseContentData(true);
            }
            this.stateStack.push(4, rdd);
        }
    }

    private void handleRepositoryState(String element, Attributes attributes) {
        if (element.equals("offering")) {
            String[] values = this.parseAttributes(element, attributes, new String[]{"id", "version"}, new String[0]);
            RepositoryDigestOfferingData offering = new RepositoryDigestOfferingData(new SimpleIdentity(values[0]), new Version(values[1]));
            RepositoryDigestRepositoryData repData = (RepositoryDigestRepositoryData)this.stateStack.peekObject();
            repData.addOfferingData(offering);
            this.stateStack.push(5, offering);
        } else if (element.equals("fix")) {
            String[] values = this.parseAttributes(element, attributes, new String[]{"id", "version", "offeringId", "offeringVersion"}, new String[0]);
            RepositoryDigestFixData fix = new RepositoryDigestFixData(values[0], values[1], values[2], values[3]);
            RepositoryDigestRepositoryData repData = (RepositoryDigestRepositoryData)this.stateStack.peekObject();
            repData.addFixData(fix);
            this.stateStack.push(6, fix);
        } else if (element.equals("toc")) {
            RepositoryDigestToc newToc;
            String[] values = this.parseAttributes(element, attributes, new String[0], new String[]{"fileCount"});
            if (values[0] != null) {
                int iFileCount = Integer.parseInt(values[0]);
                newToc = new RepositoryDigestToc(iFileCount);
            } else {
                newToc = new RepositoryDigestToc();
            }
            RepositoryDigestRepositoryData repData = (RepositoryDigestRepositoryData)this.stateStack.peekObject();
            repData.setToc(newToc);
            this.stateStack.push(11, newToc);
        } else if (element.equals("repository")) {
            String[] values = this.parseAttributes(element, attributes, new String[0], new String[]{"name", "location", "useContentData"});
            RepositoryDigestRepositoryData repData = (RepositoryDigestRepositoryData)this.stateStack.peekObject();
            RepositoryDigestRepositoryData rdd = repData.getRepositoryDigestData(values[0], values[1]);
            if (values[2] != null) {
                rdd.setUseContentData(Boolean.valueOf(values[2]));
            } else {
                rdd.setUseContentData(true);
            }
            LinkedProperties parentRepProps = repData.getProperties();
            if (parentRepProps.containsKey("Unavailable")) {
                rdd.getProperties().put("Unavailable", parentRepProps.get("Unavailable"));
            }
            this.stateStack.push(4, rdd);
        } else if (element.equals("dictionary")) {
            RepositoryDigestRepositoryData data = (RepositoryDigestRepositoryData)this.stateStack.peekObject();
            String[] values = this.parseAttributes(element, attributes, new String[]{"lang"}, new String[0]);
            RepositoryDigestDictionary dict = new RepositoryDigestDictionary(values[0]);
            data.addDictionary(dict);
            this.stateStack.push(9, dict);
        } else if (element.equals("property")) {
            this.handleProperty(attributes);
        }
    }

    private void endRepositoryState() {
        RepositoryDigestRepositoryData repData = (RepositoryDigestRepositoryData)this.stateStack.peekObject();
        repData.end(this.m_inputStreamUrl, this.m_remotePath);
    }

    private void handleProperty(Attributes attributes) {
        XMLParser.PropertyPair p = this.parseProperty(attributes);
        if (!p.isValid()) {
            return;
        }
        switch (this.stateStack.peekState()) {
            case 4: {
                RepositoryDigestRepositoryData repData = (RepositoryDigestRepositoryData)this.stateStack.peekObject();
                repData.setProperty(p.name, p.value);
                break;
            }
            case 9: {
                RepositoryDigestDictionary dict = (RepositoryDigestDictionary)this.stateStack.peekObject();
                dict.addProperty(p.name, p.value);
                break;
            }
            case 5: {
                RepositoryDigestOfferingData odd = (RepositoryDigestOfferingData)this.stateStack.peekObject();
                odd.addUntranslatedProperty(p.name, p.value);
                break;
            }
            case 6: {
                RepositoryDigestFixData fdd = (RepositoryDigestFixData)this.stateStack.peekObject();
                fdd.addUntranslatedProperty(p.name, p.value);
                break;
            }
            default: {
                throw new XMLParser.BadStateError(this);
            }
        }
        this.stateStack.push(1, null);
    }

    private void handleOfferingState(String element, Attributes attributes) {
        if (element.equals("information")) {
            RepositoryDigestOfferingData data = (RepositoryDigestOfferingData)this.stateStack.peekObject();
            String[] values = this.parseAttributes(element, attributes, new String[0], new String[]{"name", "version"});
            data.setInformation(values[0], values[1]);
            this.stateStack.push(8, data.getInformation());
        } else if (element.equals("dictionary")) {
            RepositoryDigestOfferingData data = (RepositoryDigestOfferingData)this.stateStack.peekObject();
            String[] values = this.parseAttributes(element, attributes, new String[]{"lang"}, new String[0]);
            RepositoryDigestDictionary dict = new RepositoryDigestDictionary(values[0]);
            data.addDictionary(dict);
            this.stateStack.push(9, dict);
        } else if (element.equals("baseOffering")) {
            RepositoryDigestOfferingData data = (RepositoryDigestOfferingData)this.stateStack.peekObject();
            String[] values = this.parseAttributes(element, attributes, new String[0], new String[]{"id", "version", "displayVersion"});
            RepositoryDigestBaseOfferingData base = new RepositoryDigestBaseOfferingData(new SimpleIdentity(values[0]), new Version(values[1]), values[2]);
            data.setBaseOfferingInfo(base);
            this.stateStack.push(9, base);
        } else if (element.equals("file")) {
            RepositoryDigestOfferingData data = (RepositoryDigestOfferingData)this.stateStack.peekObject();
            this.updateToc(data.getToc(), element, attributes);
            this.stateStack.push(10, null);
        } else if (element.equals("property")) {
            this.handleProperty(attributes);
        }
    }

    private void handleFixState(String element, Attributes attributes) {
        if (element.equals("information")) {
            RepositoryDigestFixData data = (RepositoryDigestFixData)this.stateStack.peekObject();
            String[] values = this.parseAttributes(element, attributes, new String[0], new String[]{"name", "version"});
            data.setInformation(values[0], values[1]);
            this.stateStack.push(8, data.getInformation());
        } else if (element.equals("dictionary")) {
            RepositoryDigestFixData data = (RepositoryDigestFixData)this.stateStack.peekObject();
            String[] values = this.parseAttributes(element, attributes, new String[]{"lang"}, new String[0]);
            RepositoryDigestDictionary dict = new RepositoryDigestDictionary(values[0]);
            data.addDictionary(dict);
            this.stateStack.push(9, dict);
        } else if (element.equals("file")) {
            RepositoryDigestFixData data = (RepositoryDigestFixData)this.stateStack.peekObject();
            this.updateToc(data.getToc(), element, attributes);
            this.stateStack.push(10, null);
        } else if (element.equals("property")) {
            this.handleProperty(attributes);
        }
    }

    @Override
    public void unexpectedAttribute(String element, String attribute, String value) {
    }

    private void handleInformationState(String element, Attributes attributes) {
    }

    private void handleDictionaryState(String element, Attributes attributes) {
        if (element.equals("property")) {
            this.handleProperty(attributes);
        }
    }

    private void handleFileState(String element, Attributes attributes) {
    }

    private void handleTocState(String element, Attributes attributes) {
        if (element.equals("file")) {
            RepositoryDigestToc data = (RepositoryDigestToc)this.stateStack.peekObject();
            this.updateToc(data, element, attributes);
            this.stateStack.push(10, null);
        }
    }

    private void updateToc(RepositoryDigestToc a_toc, String a_element, Attributes a_attributes) {
        ArrayList<String> attrNames = new ArrayList<String>();
        attrNames.add("alias");
        attrNames.add("size");
        attrNames.addAll(DigestAttributes.DIGEST_NAMES);
        String[] keys = attrNames.toArray(new String[attrNames.size()]);
        String[] values = this.parseAttributes(a_element, a_attributes, new String[]{"name"}, keys);
        RepositoryDigestTocEntry entry = new RepositoryDigestTocEntry(new CicFileLocation(values[0]), values[1], null);
        FileContentInfo sci = entry.getContentInfo();
        if (values[2] != null) {
            long size = Long.parseLong(values[2]);
            sci.setSize(size);
        }
        int i = 3;
        while (i < values.length) {
            if (values[i] != null) {
                sci.setDigestValue(keys[i - 1], values[i]);
            }
            ++i;
        }
        a_toc.addEntry(entry);
    }
}

