/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.proxy.IOfferingOrFixReference;
import com.ibm.cic.common.core.repository.IRepository;

public class UnavailableUtils {
    public static final String ENTITLEMENT = "entitlement";

    public static String getUnavailableReason(IContent content) {
        if (content instanceof IOfferingOrFixReference) {
            IOfferingOrFixReference ref = (IOfferingOrFixReference)content;
            return ref.getUnavailableReason();
        }
        return null;
    }

    public static boolean isUnavailable(IContent content) {
        return UnavailableUtils.getUnavailableReason(content) != null;
    }

    public static boolean isUnavailable(IRepository repo) {
        return repo != null && !repo.getSiteProperties().getProperty("Unavailable").equals("");
    }

    public static String getEntitlementHelpURL(IRepository repo) {
        String result = null;
        if (repo != null) {
            result = repo.getSiteProperties().getProperty("entitlement.help.url");
        }
        return result;
    }

    public static String getEntitlementHelpURL(IContent content) {
        if (content != null) {
            return UnavailableUtils.getEntitlementHelpURL(content.getRepository());
        }
        return null;
    }
}

