/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.ZipRepository;

public class JarRepository
extends ZipRepository {
    public static final String REPOSITORY_TYPE = "Jar";
    public static final String REPOSITORY_VERSION = "0.0.0.1";

    public JarRepository() {
        this(REPOSITORY_TYPE, REPOSITORY_VERSION);
    }

    protected JarRepository(String type, String version) {
        super(type, version);
    }

    @Override
    public String getDotFileExt() {
        return CicConstants.getJarFileDotExt();
    }

    @Override
    protected IRepositoryInfo createSubRepositoryInfo(ICicLocation relLoc, String a_fileName) {
        IRepositoryInfo return_value = null;
        if (CicConstants.fileMatchesDEFAULT_EXTENSIONS(a_fileName) || a_fileName.endsWith(CicConstants.getJarFileDotExt())) {
            return_value = RepositoryGroup.getDefault().createRepositoryInfo(a_fileName, "ContentJar2", REPOSITORY_VERSION, this.m_subRepositoryLocation, null);
        } else if (a_fileName.endsWith(CicConstants.getZipFileDotExt())) {
            return_value = RepositoryGroup.getDefault().createRepositoryInfo(a_fileName, "ContentZip2", REPOSITORY_VERSION, this.m_subRepositoryLocation.append(relLoc).append(a_fileName), null);
        }
        return return_value;
    }
}

