/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.internal.repository.RepositoryInfo;
import com.ibm.cic.common.core.repository.CicFileLocation;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IEnclosingVolumeRepositoryContext;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.RepositoryContext;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryStatus;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.FileURLUtil;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

class EnclosingVolumeRepositoryContextChecker
extends RepositoryContext.AbstractRepositoryContext
implements IEnclosingVolumeRepositoryContext {
    private static final String ARG_PATH = "path";

    public EnclosingVolumeRepositoryContextChecker() {
        super("EnclosingVolumeRepository");
    }

    @Override
    public IStatus checkRequiredContext(IRepositoryInfo repoInfo, Map repoProperties) {
        if (!this.hasThisRequireContext(repoProperties)) {
            return Status.OK_STATUS;
        }
        this.parseNamedArguments();
        Map args = this.getNamedArguments();
        String path = this.getArgument(args, ARG_PATH);
        if (this.hasThisContext(repoInfo)) {
            return this.result(repoInfo, Status.OK_STATUS);
        }
        CicFileLocation relativePath = new CicFileLocation(path);
        ICicLocation diskLocation = repoInfo.getLocation().appendRelative(relativePath);
        if (!FileURLUtil.isFileLocation(diskLocation.toString())) {
            String msg = NLS.bind(Messages.EnclosingVolumeRepositoryContextChecker_mustBeOpenedViaEnclosingDiskSet, (Object)repoInfo.getLocationStr());
            return this.result(repoInfo, Statuses.ERROR.get(6020, msg, new Object[0]));
        }
        RepositoryGroup tmpGroup = new RepositoryGroup(this.getClass().getName());
        RepositoryInfo diskRepoInfo = new RepositoryInfo(this.getClass().getName(), "Volume", null, diskLocation, null);
        diskRepoInfo.setProperty("AllowOpenFromAnyESDDisk", Boolean.TRUE);
        try {
            IStatus status = tmpGroup.canAddExistingRepository(diskRepoInfo, null);
            if (status.isOK()) {
                ICicLocation disk1Location = (ICicLocation)diskRepoInfo.getProperty("disk1Location");
                IStatus iStatus = this.result(repoInfo, Statuses.ERROR.get(6020, Messages.EnclosingVolumeRepositoryContextChecker_mustBeOpenedViaDisk1At, repoInfo.getLocationStr(), disk1Location));
                return iStatus;
            }
            if (status.matches(4)) {
                RepositoryStatus.StatusAndErrorType displayStatus = RepositoryStatus.getDisplayStatusForCanAddExisting("", status);
                if (displayStatus.isKnownInvalidLocation()) {
                    if (displayStatus.getCode() == 15) {
                        IStatus iStatus = this.result(repoInfo, Statuses.ERROR.get(6020, Messages.EnclosingVolumeRepositoryContextChecker_disk1WasNotFound, repoInfo.getLocationStr()));
                        return iStatus;
                    }
                    CicMultiStatus ms = Statuses.ST.createMultiStatus(6020, Messages.EnclosingVolumeRepositoryContextChecker_errorLocatingEnclosingDisk, repoInfo.getLocationStr());
                    ms.addAll(displayStatus);
                    IStatus iStatus = this.result(repoInfo, ms);
                    return iStatus;
                }
                if (displayStatus.matches(4)) {
                    CicMultiStatus ms = Statuses.ERROR.getMultiStatus(6020, null, Messages.EnclosingVolumeRepositoryContextChecker_errorLocatingEnclosingDisk, repoInfo.getLocationStr());
                    ms.addAll(displayStatus);
                    IStatus iStatus = this.result(repoInfo, ms);
                    return iStatus;
                }
                IStatus iStatus = this.result(repoInfo, Statuses.ERROR.get(6020, Messages.EnclosingVolumeRepositoryContextChecker_errorLocatingEnclosingDisk, repoInfo.getLocationStr()));
                return iStatus;
            }
            if (status.matches(3)) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            IStatus iStatus = status;
            return iStatus;
        }
        finally {
            tmpGroup.removeAllRepositories();
        }
    }

    private String getArgument(Map args, String argument) {
        return this.getArgument(args, argument, this.getRequireContextSyntax());
    }

    private String getRequireContextSyntax() {
        return NLS.bind(Messages.EnclosingVolumeRepositoryContextChecker_expectedSyntax, "RequireContext", this.getRepositoryContextId(), ARG_PATH);
    }

    @Override
    public String getContextValue(IPath path) {
        return NLS.bind("{0}:path={1}", (Object)"EnclosingVolumeRepository", (Object)path);
    }
}

