/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.repository.UpdateAssembly;
import com.ibm.cic.common.core.internal.repository.UpdateIU;
import com.ibm.cic.common.core.internal.repository.UpdateOffering;
import com.ibm.cic.common.core.internal.repository.UpdateSU;
import com.ibm.cic.common.core.internal.utils.CicCommonCorePluginTrace;
import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.repository.AbstractBaseRepository;
import com.ibm.cic.common.core.repository.IContentRepository;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryCacheHandler;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.IRepositoryRef;
import com.ibm.cic.common.core.repository.RepositorySiteProperties;
import com.ibm.cic.common.core.repository.UpdateOfferingUtils;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestRepositoryData;
import com.ibm.cic.common.core.repository.listeners.IRepositoryPropertyEventListener;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventContentAddRemove;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventContentChanged;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventProperty;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public abstract class AbstractRepositoryCacheHandler
extends AbstractBaseRepository
implements IRepositoryCacheHandler,
IRepositoryPropertyEventListener {
    protected IRepository m_targetRepository;
    protected IRepository m_cacheRepository;
    private boolean m_offeringsCacheIsUpdated = false;
    private boolean m_updatesCacheIsUpdated = false;
    private boolean m_fixesCacheIsUpdated = false;
    private boolean m_assembliesCacheIsUpdated = false;
    private boolean m_susCacheIsUpdated = false;
    private boolean m_suFragmentsCacheIsUpdated = false;
    private boolean m_iusCacheIsUpdated = false;
    private static final CicCommonCorePluginTrace m_trace = ComIbmCicCommonCorePlugin.getTrace();

    public AbstractRepositoryCacheHandler(String repType, String repVersion) {
        super(repType, repVersion);
    }

    @Override
    public IRepository getRepository() {
        return this.m_targetRepository;
    }

    @Override
    public void setReferencedRepository(IRepository repository) {
        if (this.m_targetRepository != null) {
            this.m_targetRepository.unregisterListener(this);
        }
        this.m_targetRepository = repository;
        this.cleanCache();
        this.m_targetRepository.registerListener(this);
    }

    @Override
    public boolean setUpRepositories(IRepository target, IRepository cache) {
        this.m_cacheRepository = cache;
        this.setReferencedRepository(target);
        this.m_cacheRepository.setRepositoryReference(this.m_targetRepository.getRepositoryReference());
        return this.m_cacheRepository.isWritable();
    }

    public boolean isTargetWritable() {
        return this.m_targetRepository.isWritable() && this.m_targetRepository.getStatus(true, null).isOK();
    }

    @Override
    public List getAllOfferings(boolean includeUnavailable, IProgressMonitor progressMonitor) {
        if (!this.isOpen()) {
            return Collections.EMPTY_LIST;
        }
        if (this.cachedAllOfferings(progressMonitor)) {
            return this.m_cacheRepository.getAllOfferings(includeUnavailable, progressMonitor);
        }
        return this.m_targetRepository.getAllOfferings(includeUnavailable, progressMonitor);
    }

    @Override
    public List getAllUpdates(boolean includeUnavailable, IIdentity offeringId, Version offeringVersion, IProgressMonitor progressMonitor) {
        if (!this.isOpen()) {
            return Collections.EMPTY_LIST;
        }
        if (this.cachedAllUpdates(progressMonitor)) {
            return this.m_cacheRepository.getAllUpdates(includeUnavailable, offeringId, offeringVersion, progressMonitor);
        }
        return this.m_targetRepository.getAllUpdates(includeUnavailable, offeringId, offeringVersion, progressMonitor);
    }

    private boolean cachedAllOfferings(IProgressMonitor progressMonitor) {
        if (!this.m_offeringsCacheIsUpdated) {
            List list = this.m_targetRepository.getAllOfferings(true, progressMonitor);
            try {
                if (this.m_cacheRepository.addContent(list).isOK()) {
                    this.m_offeringsCacheIsUpdated = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.m_offeringsCacheIsUpdated;
    }

    private boolean cachedAllUpdates(IProgressMonitor progressMonitor) {
        if (!this.m_updatesCacheIsUpdated) {
            List list = this.m_targetRepository.getAllUpdates(true, null, null, progressMonitor);
            try {
                if (this.m_cacheRepository.addContent(list).isOK()) {
                    this.m_updatesCacheIsUpdated = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.m_updatesCacheIsUpdated;
    }

    @Override
    public List getAllFixes(boolean includeUnavailable, IProgressMonitor progressMonitor) {
        if (!this.isOpen()) {
            return Collections.EMPTY_LIST;
        }
        if (this.cachedAllFixes(progressMonitor)) {
            return this.m_cacheRepository.getAllFixes(includeUnavailable, progressMonitor);
        }
        return this.m_targetRepository.getAllFixes(includeUnavailable, progressMonitor);
    }

    private boolean cachedAllFixes(IProgressMonitor progressMonitor) {
        if (!this.m_fixesCacheIsUpdated) {
            List list = this.m_targetRepository.getAllFixes(true, progressMonitor);
            try {
                if (this.m_cacheRepository.addContent(list).isOK()) {
                    this.m_fixesCacheIsUpdated = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.m_fixesCacheIsUpdated;
    }

    @Override
    public List getAllAssemblies(IProgressMonitor progressMonitor) {
        if (!this.isOpen()) {
            return Collections.EMPTY_LIST;
        }
        if (this.cachedAllAssemblies(progressMonitor)) {
            return this.m_cacheRepository.getAllAssemblies(progressMonitor);
        }
        return this.m_targetRepository.getAllAssemblies(progressMonitor);
    }

    private boolean cachedAllAssemblies(IProgressMonitor progressMonitor) {
        if (!this.m_assembliesCacheIsUpdated) {
            List list = this.m_targetRepository.getAllAssemblies(progressMonitor);
            try {
                if (this.m_cacheRepository.addContent(list).isOK()) {
                    this.m_assembliesCacheIsUpdated = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.m_assembliesCacheIsUpdated;
    }

    @Override
    public List getAllSus(IProgressMonitor progressMonitor) {
        if (!this.isOpen()) {
            return Collections.EMPTY_LIST;
        }
        if (this.cachedAllSus(progressMonitor)) {
            return this.m_cacheRepository.getAllSus(progressMonitor);
        }
        return this.m_targetRepository.getAllSus(progressMonitor);
    }

    @Override
    public List getAllSuFragments(IProgressMonitor progressMonitor) {
        if (!this.isOpen()) {
            return Collections.EMPTY_LIST;
        }
        if (this.cachedAllSuFragments(progressMonitor)) {
            return this.m_cacheRepository.getAllSuFragments(progressMonitor);
        }
        return this.m_targetRepository.getAllSuFragments(progressMonitor);
    }

    private boolean cachedAllSus(IProgressMonitor progressMonitor) {
        if (!this.m_susCacheIsUpdated) {
            List list = this.m_targetRepository.getAllSus(progressMonitor);
            try {
                if (this.m_cacheRepository.addContent(list).isOK()) {
                    this.m_susCacheIsUpdated = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.m_susCacheIsUpdated;
    }

    private boolean cachedAllSuFragments(IProgressMonitor progressMonitor) {
        if (!this.m_suFragmentsCacheIsUpdated) {
            List list = this.m_targetRepository.getAllSuFragments(progressMonitor);
            try {
                if (this.m_cacheRepository.addContent(list).isOK()) {
                    this.m_suFragmentsCacheIsUpdated = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.m_suFragmentsCacheIsUpdated;
    }

    @Override
    public List getAllShareableEntities(IProgressMonitor progressMonitor) {
        if (!this.isOpen()) {
            return Collections.EMPTY_LIST;
        }
        if (this.cachedAllSus(progressMonitor) && this.cachedAllAssemblies(progressMonitor)) {
            return this.m_cacheRepository.getAllShareableEntities(progressMonitor);
        }
        return this.m_targetRepository.getAllShareableEntities(progressMonitor);
    }

    @Override
    public List getAllIus(IProgressMonitor progressMonitor) {
        if (!this.isOpen()) {
            return Collections.EMPTY_LIST;
        }
        if (this.cachedAllIus(progressMonitor)) {
            return this.m_cacheRepository.getAllIus(progressMonitor);
        }
        return this.m_targetRepository.getAllIus(progressMonitor);
    }

    private boolean cachedAllIus(IProgressMonitor progressMonitor) {
        if (!this.m_iusCacheIsUpdated) {
            List list = this.m_targetRepository.getAllIus(progressMonitor);
            try {
                if (this.m_cacheRepository.addContent(list).isOK()) {
                    this.m_iusCacheIsUpdated = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.m_iusCacheIsUpdated;
    }

    @Override
    public IReadArtifactRepo.IArtifactTocCapabilities getArtifactTocCapabilities() {
        return this.m_targetRepository.getArtifactTocCapabilities();
    }

    @Override
    public boolean hasArtifactToc(IArtifactSession session, IProgressMonitor monitor) throws CoreException {
        return this.m_targetRepository.hasArtifactToc(session, monitor);
    }

    @Override
    public IReadArtifactRepo.IArtifactToc readArtifactToc(IArtifactSession session, IProgressMonitor monitor) throws CoreException {
        return this.m_targetRepository.readArtifactToc(session, monitor);
    }

    @Override
    public IReadArtifactRepo.IArtifactToc readCachedArtifactToc(IArtifactSession session, IPath tocCache, IProgressMonitor monitor) throws CoreException {
        return this.m_targetRepository.readCachedArtifactToc(session, tocCache, monitor);
    }

    @Override
    public Object getAdapter(Class adapter) {
        return this.m_targetRepository.getAdapter(adapter);
    }

    @Override
    public IStatus clear() {
        this.cleanCache();
        return this.m_targetRepository.clear();
    }

    @Override
    public void setOpen(boolean isOpen) {
        this.m_targetRepository.setOpen(isOpen);
    }

    @Override
    public boolean isOpen() {
        return this.m_targetRepository.isOpen();
    }

    @Override
    public void refresh() {
        this.m_targetRepository.refresh();
        this.cleanCache();
    }

    @Override
    public IContent refreshContent(IContent content) {
        IContent return_value = this.m_targetRepository.refreshContent(content);
        if (return_value != null) {
            return_value = this.findCachedContent(return_value);
        }
        return return_value;
    }

    protected void cleanCache() {
        this.m_offeringsCacheIsUpdated = false;
        this.m_updatesCacheIsUpdated = false;
        this.m_fixesCacheIsUpdated = false;
        this.m_assembliesCacheIsUpdated = false;
        this.m_susCacheIsUpdated = false;
        this.m_suFragmentsCacheIsUpdated = false;
        this.m_iusCacheIsUpdated = false;
        this.m_cacheRepository.clear();
    }

    @Override
    public IRepositoryInfo getRepositoryInfo() {
        return this.m_targetRepository.getRepositoryInfo();
    }

    @Override
    public String serializeRepositoryInfo() {
        return this.m_targetRepository.serializeRepositoryInfo();
    }

    @Override
    protected IStatus doAddContent(IContent content) throws IOException {
        IContent return_value = this.m_targetRepository.addContent(content);
        if (return_value != null && this.isCacheLoaded(return_value)) {
            this.m_cacheRepository.addContent(return_value);
        }
        return this.getStatus(false, null);
    }

    @Override
    public IStatus deleteContent(IContent content) throws IOException {
        IStatus return_value = this.m_targetRepository.deleteContent(content);
        if (return_value.isOK()) {
            this.m_cacheRepository.deleteContent(this.findContent(content));
        }
        return return_value;
    }

    @Override
    public IStatus delete(boolean mustClear) {
        IStatus return_value = this.m_targetRepository.delete(mustClear);
        if (return_value.isOK()) {
            this.m_cacheRepository.delete(mustClear);
        }
        this.cleanCache();
        return return_value;
    }

    @Override
    public void dispose() {
        this.m_targetRepository.dispose();
        this.cleanCache();
        this.m_cacheRepository.dispose();
    }

    @Override
    public IStatus saveContent(IContent content) throws IOException {
        IStatus return_value = this.m_targetRepository.saveContent(content);
        if (return_value.isOK()) {
            this.m_cacheRepository.saveContent(content);
        }
        return return_value;
    }

    @Override
    public IAssembly findAssembly(IIdentity id, Version version, IProgressMonitor progressMonitor) {
        if (this.cachedAllAssemblies(progressMonitor)) {
            return this.m_cacheRepository.findAssembly(id, version, progressMonitor);
        }
        return this.m_targetRepository.findAssembly(id, version, progressMonitor);
    }

    @Override
    public IInstallableUnit findInstallableUnit(IIdentity id, Version version, IProgressMonitor progressMonitor) {
        if (this.cachedAllIus(progressMonitor)) {
            return this.m_cacheRepository.findInstallableUnit(id, version, progressMonitor);
        }
        return this.m_targetRepository.findInstallableUnit(id, version, progressMonitor);
    }

    @Override
    public IOffering findOffering(IIdentity id, Version version, IProgressMonitor progressMonitor) {
        if (this.cachedAllOfferings(progressMonitor)) {
            return this.m_cacheRepository.findOffering(id, version, progressMonitor);
        }
        return this.m_targetRepository.findOffering(id, version, progressMonitor);
    }

    @Override
    public IOffering findUpdate(IIdentity id, Version version, IProgressMonitor progressMonitor) {
        if (this.cachedAllUpdates(progressMonitor)) {
            return this.m_cacheRepository.findUpdate(id, version, progressMonitor);
        }
        return this.m_targetRepository.findUpdate(id, version, progressMonitor);
    }

    @Override
    public IStatus unsetUpdateOffering(IOffering updateOffering) {
        this.cleanCache();
        return this.m_targetRepository.unsetUpdateOffering(updateOffering);
    }

    @Override
    public IFix findFix(IIdentity id, Version version, IProgressMonitor progressMonitor) {
        if (this.cachedAllFixes(progressMonitor)) {
            return this.m_cacheRepository.findFix(id, version, progressMonitor);
        }
        return this.m_targetRepository.findFix(id, version, progressMonitor);
    }

    @Override
    public List getShareableEntities(IIdentity id, Version version, VersionRange tolerance, IProgressMonitor progressMonitor) {
        if (this.cachedAllSus(progressMonitor) && this.cachedAllAssemblies(progressMonitor)) {
            return this.m_cacheRepository.getShareableEntities(id, version, tolerance, progressMonitor);
        }
        return this.m_targetRepository.getShareableEntities(id, version, tolerance, progressMonitor);
    }

    @Override
    public IShareableUnit findShareableUnit(IIdentity id, Version version, IProgressMonitor progressMonitor) {
        if (this.cachedAllSus(progressMonitor)) {
            return this.m_cacheRepository.findShareableUnit(id, version, progressMonitor);
        }
        return this.m_targetRepository.findShareableUnit(id, version, progressMonitor);
    }

    @Override
    public ISuFragment findSuFragment(IIdentity id, Version version, IProgressMonitor progressMonitor) {
        if (this.cachedAllSuFragments(progressMonitor)) {
            return this.m_cacheRepository.findSuFragment(id, version, progressMonitor);
        }
        return this.m_targetRepository.findSuFragment(id, version, progressMonitor);
    }

    @Override
    public List getAllContentElements(IProgressMonitor progressMonitor) {
        if (this.cachedAllSus(progressMonitor) && this.cachedAllSuFragments(progressMonitor) && this.cachedAllIus(progressMonitor) && this.cachedAllAssemblies(progressMonitor) && this.cachedAllOfferings(progressMonitor) && this.cachedAllUpdates(progressMonitor) && this.cachedAllFixes(progressMonitor)) {
            return this.m_cacheRepository.getAllContentElements(progressMonitor);
        }
        return this.m_targetRepository.getAllContentElements(progressMonitor);
    }

    @Override
    public String getName() {
        return this.m_targetRepository.getName();
    }

    @Override
    public String getType() {
        return this.m_targetRepository.getType();
    }

    @Override
    public String getVersion() {
        return this.m_targetRepository.getVersion();
    }

    @Override
    public boolean isWritable() {
        return this.m_targetRepository.isWritable();
    }

    @Override
    public void registerListener(IRepositoryPropertyEventListener listener) {
        this.m_targetRepository.registerListener(listener);
    }

    @Override
    public void setName(String name) {
        this.m_targetRepository.setName(name);
    }

    @Override
    public void unregisterListener(IRepositoryPropertyEventListener listener) {
        this.m_targetRepository.unregisterListener(listener);
    }

    @Override
    public boolean containsMetadata() {
        IProgressMonitor progressMonitor = null;
        if (this.cachedAllSus(progressMonitor) && this.cachedAllSuFragments(progressMonitor) && this.cachedAllIus(progressMonitor) && this.cachedAllAssemblies(progressMonitor) && this.cachedAllOfferings(progressMonitor) && this.cachedAllUpdates(progressMonitor) && this.cachedAllFixes(progressMonitor)) {
            return this.m_cacheRepository.containsMetadata();
        }
        return this.m_targetRepository.containsMetadata();
    }

    @Override
    public boolean containsArtifacts() {
        return this.m_targetRepository.containsArtifacts();
    }

    @Override
    public InputStream getContentInputStream(IContent content) throws IOException {
        return this.m_targetRepository.getContentInputStream(content);
    }

    @Override
    public InputStream getInputStream(String relativePath) throws IOException {
        return this.m_targetRepository.getInputStream(relativePath);
    }

    @Override
    public IRepository getRepositoryReference() {
        IRepository ref = this.m_targetRepository.getRepositoryReference();
        if (ref instanceof IRepositoryRef) {
            ((IRepositoryRef)ref).setReferencedRepository(this);
        }
        return ref;
    }

    @Override
    public void setRepositoryReference(IRepository repository) {
        this.m_targetRepository.setRepositoryReference(repository);
    }

    @Override
    public boolean canStoreArtifacts() {
        return this.m_targetRepository.canStoreArtifacts();
    }

    @Override
    public boolean canStoreMetadata() {
        return this.m_targetRepository.canStoreMetadata();
    }

    @Override
    public IStatus getStatus(boolean forceReEvaluation, IProgressMonitor progressMonitor) {
        return this.m_targetRepository.getStatus(forceReEvaluation, progressMonitor);
    }

    @Override
    public IContent moveContent(IContent content) throws IOException {
        return super.moveContent(content);
    }

    public static void updateContent(IContent content1, IContent content2) throws InvocationTargetException {
        if (content1 instanceof IOffering && content2 instanceof IOffering) {
            new UpdateOffering().updateIncludes(content1, content2);
        } else if (content1 instanceof IAssembly && content2 instanceof IAssembly) {
            new UpdateAssembly().updateIncludes(content1, content2);
        } else if (content1 instanceof IShareableUnit && content2 instanceof IShareableUnit) {
            new UpdateSU().updateIncludes(content1, content2);
        } else if (content1 instanceof IInstallableUnit && content2 instanceof IInstallableUnit) {
            new UpdateIU().updateIncludes(content1, content2);
        }
    }

    @Override
    public IStatus canAddExistingRepository(IProgressMonitor progressMonitor) {
        return this.m_targetRepository.canAddExistingRepository(progressMonitor);
    }

    @Override
    public IStatus canCreateRepository() {
        return this.m_targetRepository.canCreateRepository();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nCacheHandler_target: ");
        sb.append(this.m_targetRepository != null ? this.m_targetRepository.toString() : "null");
        sb.append("\nCacheHandler_cache: ");
        sb.append(this.m_cacheRepository != null ? this.m_cacheRepository.toString() : "null");
        return sb.toString();
    }

    @Override
    public IStatus resolve(IOfferingOrFix element, IProgressMonitor progressMonitor) {
        if (this.cachedAllSus(progressMonitor) && this.cachedAllSuFragments(progressMonitor) && this.cachedAllIus(progressMonitor) && this.cachedAllAssemblies(progressMonitor)) {
            return this.m_cacheRepository.resolve(element, progressMonitor);
        }
        return this.m_targetRepository.resolve(element, progressMonitor);
    }

    @Override
    public void repositoryPropertyEventOccurred(RepositoryEventProperty event) {
        if (event instanceof RepositoryEventContentAddRemove) {
            RepositoryEventContentAddRemove e = (RepositoryEventContentAddRemove)event;
            IContent content1 = this.findCachedContent(e.getContent());
            if (e.isAdded()) {
                if (content1 == null) {
                    try {
                        if (this.isCacheLoaded(e.getContent())) {
                            this.m_cacheRepository.addContent(e.getContent());
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            } else if (content1 != null) {
                try {
                    if (this.isCacheLoaded(e.getContent())) {
                        this.m_cacheRepository.deleteContent(content1);
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            } else if (AbstractRepositoryCacheHandler.m_trace.enabled) {
                m_trace.println("Did not find to delete " + e.getContent().toString() + " IN " + this.m_cacheRepository.getName());
            }
        } else if (event instanceof RepositoryEventContentChanged) {
            RepositoryEventContentChanged e = (RepositoryEventContentChanged)event;
            IContent content1 = this.findCachedContent(e.getContent());
            if (content1 != null) {
                try {
                    AbstractRepositoryCacheHandler.updateContent(content1, e.getContent());
                }
                catch (InvocationTargetException e1) {
                    e1.printStackTrace();
                }
            } else if (AbstractRepositoryCacheHandler.m_trace.enabled) {
                m_trace.println("Did not find to delete " + e.getContent().toString() + " IN " + this.m_cacheRepository.getName());
            }
        }
    }

    boolean isCacheLoaded(IContent contentType) {
        if (contentType instanceof IOffering) {
            if (UpdateOfferingUtils.isUpdate(contentType)) {
                return this.m_updatesCacheIsUpdated;
            }
            return this.m_offeringsCacheIsUpdated;
        }
        if (contentType instanceof IFix) {
            return this.m_fixesCacheIsUpdated;
        }
        if (contentType instanceof IAssembly) {
            return this.m_assembliesCacheIsUpdated;
        }
        if (contentType instanceof IShareableUnit) {
            return this.m_susCacheIsUpdated;
        }
        if (contentType instanceof ISuFragment) {
            return this.m_suFragmentsCacheIsUpdated;
        }
        if (contentType instanceof IInstallableUnit) {
            return this.m_iusCacheIsUpdated;
        }
        return false;
    }

    IContent findCachedContent(IContent sourceContent) {
        IContent return_value = null;
        List cached_content = null;
        if (sourceContent instanceof IOffering) {
            cached_content = UpdateOfferingUtils.isUpdate(sourceContent) ? this.m_cacheRepository.getAllUpdates(null, null, null) : this.m_cacheRepository.getAllOfferings(null);
        } else if (sourceContent instanceof IFix) {
            cached_content = this.m_cacheRepository.getAllFixes(null);
        } else if (sourceContent instanceof IAssembly) {
            cached_content = this.m_cacheRepository.getAllAssemblies(null);
        } else if (sourceContent instanceof IShareableUnit) {
            cached_content = this.m_cacheRepository.getAllSus(null);
        } else if (sourceContent instanceof ISuFragment) {
            cached_content = this.m_cacheRepository.getAllSuFragments(null);
        } else if (sourceContent instanceof IInstallableUnit) {
            cached_content = this.m_cacheRepository.getAllIus(null);
        }
        if (cached_content != null) {
            Iterator I = cached_content.iterator();
            while (I.hasNext() && return_value == null) {
                IContent cont = (IContent)I.next();
                if (!sourceContent.equals(cont) && !sourceContent.getLocation().equals(cont.getLocation())) continue;
                return_value = cont;
            }
        }
        return return_value;
    }

    @Override
    public IContentRepository getContentRepository(IContent element) {
        return this.m_targetRepository.getContentRepository(element);
    }

    @Override
    public IStatus isRepInfoMatchingRepositoryObject(IRepositoryInfo repInfo) {
        return this.m_targetRepository.isRepInfoMatchingRepositoryObject(repInfo);
    }

    @Override
    public RepositorySiteProperties getSiteProperties() {
        return this.m_targetRepository.getSiteProperties();
    }

    @Override
    public IStatus updateRepositoryDigest(int a_request, IProgressMonitor pm) {
        return this.m_targetRepository.updateRepositoryDigest(a_request, pm);
    }

    @Override
    public RepositoryDigestRepositoryData generateRepositoryDigestData(CicMultiStatus status, IProgressMonitor pm) {
        return this.m_targetRepository.generateRepositoryDigestData(status, pm);
    }

    @Override
    public RepositoryDigestRepositoryData getRepositoryDigestData() {
        return this.m_targetRepository.getRepositoryDigestData();
    }

    @Override
    public IStatus importP2Repository(File p2RepositoryFile, IProgressMonitor monitor) {
        return this.m_targetRepository.importP2Repository(p2RepositoryFile, monitor);
    }

    @Override
    public IStatus deleteP2Repository(IProgressMonitor monitor) {
        return this.m_targetRepository.deleteP2Repository(monitor);
    }

    @Override
    public IStatus exportP2Repository(File destinationFile, IProgressMonitor monitor) {
        return this.m_targetRepository.exportP2Repository(destinationFile, monitor);
    }

    @Override
    public boolean containsP2Repository(IProgressMonitor monitor) {
        return this.m_targetRepository.containsP2Repository(monitor);
    }

    @Override
    protected IStatus doImportP2Repository(File sourceP2RepositoryFile, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IStatus addNLSFile(String fileName, InputStream source) throws IOException {
        return this.m_targetRepository.addNLSFile(fileName, source);
    }

    @Override
    public IStatus deleteNLSFile(String fileName) throws IOException {
        return this.m_targetRepository.deleteNLSFile(fileName);
    }

    @Override
    public String[] getNLSFileList() {
        return this.m_targetRepository.getNLSFileList();
    }

    @Override
    public InputStream openNLSFileStream(String fileName) throws IOException {
        return this.m_targetRepository.openNLSFileStream(fileName);
    }
}

