/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.preferences;

import com.ibm.cic.common.core.internal.utils.CicParserUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.osgi.service.prefs.Preferences;

public class CicURLPreferences
implements IEclipsePreferences {
    private final Properties m_properties;
    private final URL m_url;

    public CicURLPreferences(URL filename) {
        Assert.isNotNull((Object)filename);
        this.m_properties = new Properties();
        this.m_url = filename;
    }

    public void addNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    public void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeNode() {
        throw new UnsupportedOperationException();
    }

    public Preferences node(String path) {
        throw new UnsupportedOperationException();
    }

    public void accept(IPreferenceNodeVisitor visitor) {
        throw new UnsupportedOperationException();
    }

    public void put(String key, String value) {
        String oldValue = this.m_properties.getProperty(key);
        if (oldValue == null || !oldValue.equals(value)) {
            this.m_properties.put(key, value);
        }
    }

    public String get(String key, String def) {
        String value = this.m_properties.getProperty(key);
        if (value == null) {
            return def;
        }
        return value;
    }

    public void putBoolean(String key, boolean value) {
        boolean oldValue = this.getBoolean(key, false);
        if (oldValue != value) {
            this.m_properties.put(key, Boolean.toString(value));
        }
    }

    public boolean getBoolean(String key, boolean def) {
        String value = this.m_properties.getProperty(key);
        if (value == null) {
            return def;
        }
        return value.equalsIgnoreCase("true");
    }

    public void remove(String key) {
        this.m_properties.remove(key);
    }

    public void clear() {
        this.m_properties.clear();
    }

    public void putInt(String key, int value) {
        throw new UnsupportedOperationException();
    }

    public int getInt(String key, int def) {
        throw new UnsupportedOperationException();
    }

    public void putLong(String key, long value) {
        throw new UnsupportedOperationException();
    }

    public long getLong(String key, long def) {
        throw new UnsupportedOperationException();
    }

    public void putFloat(String key, float value) {
        throw new UnsupportedOperationException();
    }

    public float getFloat(String key, float def) {
        throw new UnsupportedOperationException();
    }

    public void putDouble(String key, double value) {
        throw new UnsupportedOperationException();
    }

    public double getDouble(String key, double def) {
        throw new UnsupportedOperationException();
    }

    public void putByteArray(String key, byte[] value) {
        throw new UnsupportedOperationException();
    }

    public byte[] getByteArray(String key, byte[] def) {
        throw new UnsupportedOperationException();
    }

    public String[] keys() {
        return this.m_properties.keySet().toArray(new String[this.m_properties.keySet().size()]);
    }

    public String[] childrenNames() {
        throw new UnsupportedOperationException();
    }

    public Preferences parent() {
        throw new UnsupportedOperationException();
    }

    public boolean nodeExists(String pathName) {
        throw new UnsupportedOperationException();
    }

    public String name() {
        throw new UnsupportedOperationException();
    }

    public String absolutePath() {
        throw new UnsupportedOperationException();
    }

    public void flush() {
        throw new UnsupportedOperationException();
    }

    public void save(OutputStream out, String header) throws IOException {
        this.m_properties.store(out, header);
    }

    public void load() throws IOException {
        if (this.m_url == null) {
            throw new IOException("File name not specified");
        }
        InputStream in = CicParserUtils.getStreamForURL(this.m_url);
        if (in == null) {
            throw new IOException("File can't be opened");
        }
        this.load(in);
        in.close();
    }

    public void load(InputStream in) throws IOException {
        this.m_properties.load(in);
    }

    public void sync() {
        throw new UnsupportedOperationException();
    }
}

