/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.utils;

import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IInstallSizeInfo;
import com.ibm.cic.common.downloads.SizeInfo;

public class InstallableUnitSizeUtil {
    public static SizeInfo getSizeInfo(IInstallableUnit iu) {
        if (iu == null) {
            return new SizeInfo(0L, 0L);
        }
        SizeInfo result = new SizeInfo();
        for (IInstallSizeInfo isi : iu.getAdapterData().getInstallSizes()) {
            result.addInstallSize(isi.getInstallSize());
            IArtifact artifact = isi.getArtifact();
            if (artifact == null) continue;
            result.addDownloadSize(artifact.getContentInfo().getSizeInfo().getDownloadSize());
        }
        if (result.getDownloadSize() == Long.MIN_VALUE) {
            result.setDownloadSize(0L);
        }
        if (result.getInstallSize() == Long.MIN_VALUE) {
            result.setInstallSize(result.getDownloadSize());
        }
        return result;
    }
}

