/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FilterCollectionUtil {
    public static int countIncluded(Iterator iter, CollectionFilter filter) {
        FilterIterator ti = new FilterIterator(iter, filter);
        int count = 0;
        while (ti.hasNext()) {
            ti.next();
            ++count;
        }
        return count;
    }

    public static void filter(IteratorFactory iterFact, ArrayList list, CollectionFilter filter) {
        int n = FilterCollectionUtil.countIncluded(iterFact.createIterator(), filter);
        list.ensureCapacity(list.size() + n);
        FilterCollectionUtil.doFilter(list, iterFact.createIterator(), filter);
    }

    public static void filter(Collection original, ArrayList list, CollectionFilter filter) {
        int n = FilterCollectionUtil.countIncluded(original.iterator(), filter);
        list.ensureCapacity(list.size() + n);
        FilterCollectionUtil.doFilter(list, original.iterator(), filter);
    }

    public static void filter(Collection original, ArrayList list, Class type) {
        InstanceOfFilter filter = new InstanceOfFilter(type);
        int n = FilterCollectionUtil.countIncluded(original.iterator(), filter);
        list.ensureCapacity(list.size() + n);
        FilterCollectionUtil.doFilter(list, original.iterator(), filter);
    }

    public static ArrayList filter(Collection original, CollectionFilter filter) {
        int n = FilterCollectionUtil.countIncluded(original.iterator(), filter);
        ArrayList list = new ArrayList(n);
        FilterCollectionUtil.doFilter(list, original.iterator(), filter);
        return list;
    }

    public static ArrayList filter(Collection original, Class type) {
        InstanceOfFilter filter = new InstanceOfFilter(type);
        return FilterCollectionUtil.filter(original, filter);
    }

    public static ArrayList filter(Collection original, Class[] types) {
        CollectionFilter[] filters = new CollectionFilter[types.length];
        int i = 0;
        while (i < types.length) {
            Class type = types[i];
            filters[i] = new InstanceOfFilter(type);
            ++i;
        }
        ORFilter filter = new ORFilter(filters);
        return FilterCollectionUtil.filter(original, filter);
    }

    private static void doFilter(Collection c, Iterator iter, CollectionFilter filter) {
        FilterIterator ti = new FilterIterator(iter, filter);
        while (ti.hasNext()) {
            Object t = ti.next();
            c.add(t);
        }
    }

    public static interface CollectionFilter {
        public boolean include(Object var1);
    }

    public static class FilterIterator
    implements Iterator {
        private static final Object NONE = new Object();
        private Object next;
        private final Iterator iter;
        private final CollectionFilter filter;

        public FilterIterator(Iterator iter, CollectionFilter filter) {
            this.iter = iter;
            this.filter = filter;
            this.next = NONE;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean hasNext() {
            if (this.next == FilterIterator.NONE) ** GOTO lbl6
            return true;
lbl-1000:
            // 1 sources

            {
                this.next = this.iter.next();
                if (!this.filter.include(this.next)) continue;
                return true;
lbl6:
                // 2 sources

                ** while (this.iter.hasNext())
            }
lbl7:
            // 1 sources

            return false;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object result = this.next;
            this.next = NONE;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class InstanceOfFilter
    implements CollectionFilter {
        private final Class type;

        public InstanceOfFilter(Class type) {
            this.type = type;
        }

        @Override
        public boolean include(Object o) {
            return this.type.isInstance(o);
        }
    }

    public static interface IteratorFactory {
        public Iterator createIterator();
    }

    public static class NotFilter
    implements CollectionFilter {
        private final CollectionFilter filter;

        public NotFilter(CollectionFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean include(Object o) {
            return !this.filter.include(o);
        }
    }

    public static class ORFilter
    implements CollectionFilter {
        private final CollectionFilter[] filters;

        public ORFilter(CollectionFilter[] filters) {
            this.filters = filters;
        }

        @Override
        public boolean include(Object o) {
            CollectionFilter[] collectionFilterArray = this.filters;
            int n = this.filters.length;
            int n2 = 0;
            while (n2 < n) {
                CollectionFilter filter = collectionFilterArray[n2];
                if (filter.include(o)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

