/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.utils;

import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingIncludes;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.internal.Messages;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;

public class CompositeChecker {
    private final Map<IIdentity, IOfferingOrFix> pkgs = new HashMap<IIdentity, IOfferingOrFix>();

    public CompositeChecker offeringOrFix(IOfferingOrFix pkg) {
        this.pkgs.put(pkg.getIdentity(), pkg);
        return this;
    }

    public IStatus check(IOffering composite) {
        CicMultiStatus ms = Statuses.OK.getMultiStatus();
        for (IOfferingIncludes include : composite.getIncludes()) {
            for (IOfferingIncludes.IOfferingInProfile o : include.getOfferingsInProfile()) {
                IOfferingOrFix pkg = this.pkgs.get(o.getIdentity());
                if (pkg == null) {
                    if (!o.getKind().isRequired()) continue;
                    ms.add(Statuses.ERROR.get(Messages.CompositeChecker_Missing_Required_Package, o.getName(), composite.getName()));
                    continue;
                }
                if (pkg.getVersion().compareTo(o.getMinVersion()) < 0) {
                    ms.add(Statuses.ERROR.get(Messages.CompositeChecker_Package_Version_Too_Small, o.getName(), OfferingUtil.getDisplayableVersion(pkg), composite.getName(), o.getMinUserVersion()));
                    continue;
                }
                if (pkg.getVersion().compareTo(o.getMaxVersion()) < 0) continue;
                ms.add(Statuses.ERROR.get(Messages.CompositeChecker_Package_Version_Too_Large, o.getName(), OfferingUtil.getDisplayableVersion(pkg), composite.getName(), o.getMaxUserVersion()));
            }
        }
        return ms;
    }
}

