/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.proxy;

import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IBuilderData;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IProblemsResolved;
import com.ibm.cic.common.core.model.Information;
import com.ibm.cic.common.core.model.proxy.IOfferingOrFixReference;
import com.ibm.cic.common.core.model.proxy.LinkedPropertiesProxy;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.RepositorySiteProperties;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestOfferingOrFixData;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.logging.Logger;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Version;

public abstract class OfferingOrFixReference
implements IOfferingOrFixReference {
    static final Logger log = Logger.getLogger(OfferingOrFixReference.class);
    private IRepository m_containingRepository;
    private boolean isRecommended = false;

    @Override
    public String getUnavailableReason() {
        return this.getContentData().getUnavailableReason();
    }

    @Override
    public IStatus checkPlatform(String os, String arch) {
        return this.getContentData().checkPlatformSlice(os, arch);
    }

    @Override
    public List<String> getListOfPlatformSlices() {
        return this.getContentData().getListOfPlatformSlices();
    }

    public void setFromSiteProperties(RepositorySiteProperties siteProperties) {
        this.initContentData();
        this.getContentData().setPlatformSlice(siteProperties.getProperties());
    }

    @Override
    public IStatus addToSiteProperties(RepositorySiteProperties siteProperties) {
        this.initContentData();
        this.getContentData().addToSiteProperties(siteProperties.getProperties());
        return siteProperties.save();
    }

    @Override
    public IStatus removeFromSiteProperties(RepositorySiteProperties siteProperties) {
        this.initContentData();
        this.getContentData().removeFromSiteProperties(siteProperties.getProperties());
        return siteProperties.save();
    }

    @Override
    public boolean isPlatformSlice() {
        return this.getContentData().isPlatformSlice();
    }

    @Override
    public void setPlatformSlice(String os, String arch) {
        this.initContentData();
        this.getContentData().setPlatformSlice(os, arch);
    }

    public void setPlatformSlice(LinkedProperties siteProperties) {
        this.initContentData();
        this.getContentData().setPlatformSlice(siteProperties);
    }

    public void clearPlatformSlices() {
        this.initContentData();
        this.getContentData().clearPlatformSlices();
    }

    public void mergePlatformSlices(OfferingOrFixReference other) {
        this.initContentData();
        this.getContentData().addPlatformSlices(other.getContentData());
    }

    protected abstract IOfferingOrFix getContentElementOrNull();

    protected abstract IOfferingOrFix getModel();

    public abstract RepositoryDigestOfferingOrFixData getContentData();

    abstract void initContentData();

    protected OfferingOrFixReference() {
    }

    @Override
    public IRepository getRepository() {
        if (this.getContentElementOrNull() != null) {
            return this.getContentElementOrNull().getRepository();
        }
        return this.m_containingRepository;
    }

    @Override
    public void setRepository(IRepository containingRepository) {
        if (this.getContentElementOrNull() != null) {
            this.getContentElementOrNull().setRepository(containingRepository);
        }
        this.m_containingRepository = containingRepository;
    }

    @Override
    public boolean isRecommended() {
        return this.isRecommended;
    }

    @Override
    public void setRecommended(boolean value) {
        this.isRecommended = value;
    }

    @Override
    public String getName() {
        if (this.getContentElementOrNull() != null) {
            return this.getContentElementOrNull().getName();
        }
        return this.getContentData().getName();
    }

    @Override
    public Information getInformation() {
        if (this.getContentElementOrNull() != null) {
            return this.getContentElementOrNull().getInformation();
        }
        return this.getContentData().getInformation();
    }

    @Override
    public Version getVersion() {
        if (this.getContentElementOrNull() != null) {
            return this.getContentElementOrNull().getVersion();
        }
        return this.getContentData().getVersion();
    }

    @Override
    public IIdentity getIdentity() {
        if (this.getContentElementOrNull() != null) {
            return this.getContentElementOrNull().getIdentity();
        }
        return this.getContentData().getIdentity();
    }

    @Override
    public LinkedProperties getProperties() {
        if (this.getContentElementOrNull() != null) {
            return this.getContentElementOrNull().getProperties();
        }
        return new LinkedPropertiesProxy(this, this.getContentData().getTranslatedProperties());
    }

    @Override
    public String getProperty(String name) {
        return this.getProperties().getProperty(name);
    }

    @Override
    public String[] getPropertyNames() {
        return this.getProperties().getPropertyKeys();
    }

    @Override
    public ICicLocation getLocation() {
        if (this.getContentElementOrNull() != null) {
            return this.getContentElementOrNull().getLocation();
        }
        return this.getContentData().getLocation();
    }

    @Override
    public void setInformation(Information info) {
        this.getModel().setInformation(info);
    }

    @Override
    public IAssembly getAssembly() {
        return this.getModel().getAssembly();
    }

    @Override
    public void setAssembly(IAssembly assembly) {
        this.getModel().setAssembly(assembly);
    }

    @Override
    public IIdentity getAssemblyId() {
        return this.getModel().getAssemblyId();
    }

    @Override
    public void setAssemblyId(IIdentity assemblyId) {
        this.getModel().setAssemblyId(assemblyId);
    }

    @Override
    public Version getAssemblyVersion() {
        return this.getModel().getAssemblyVersion();
    }

    @Override
    public void setAssemblyVersion(Version assemblyVersion) {
        this.getModel().setAssemblyVersion(assemblyVersion);
    }

    @Override
    public void setIdentity(IIdentity id) {
        this.getModel().setIdentity(id);
    }

    @Override
    public void setVersion(Version version) {
        this.getModel().setVersion(version);
    }

    @Override
    public boolean hasChildren() {
        return this.getModel().hasChildren();
    }

    @Override
    public void setChildrenCount(int count) {
        this.getModel().setChildrenCount(count);
    }

    @Override
    public List getChildren() {
        if (this.getUnavailableReason() != null) {
            return Collections.EMPTY_LIST;
        }
        return this.getModel().getChildren();
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public void setLocation(ICicLocation location) {
        this.getModel().setLocation(location);
    }

    @Override
    public int compareVersion(IContent other) {
        if (other == null) {
            return 1;
        }
        if (!this.getIdentity().equals(other.getIdentity())) {
            throw new IllegalArgumentException("Mismatched ids: " + this.getIdentity() + ' ' + other.getIdentity());
        }
        return this.getVersion().compareTo(other.getVersion());
    }

    protected boolean equalsImpl(Object obj) {
        if (obj instanceof IOfferingOrFixReference) {
            IOfferingOrFixReference that = (IOfferingOrFixReference)obj;
            return this.getIdentity().equals(that.getIdentity()) && this.getVersion().equals((Object)that.getVersion());
        }
        return false;
    }

    protected int hashCodeImpl() {
        return this.getIdentity().hashCode() ^ this.getVersion().hashCode();
    }

    public String toString() {
        if (this.getContentElementOrNull() != null) {
            return this.getContentElementOrNull().toString();
        }
        return this.getContentData().toString();
    }

    @Override
    public int getLineNumber() {
        return this.getModel().getLineNumber();
    }

    @Override
    public void setLineNumber(int lineNumber) {
        this.getModel().setLineNumber(lineNumber);
    }

    @Override
    public void addInstallableUnit(IInstallableUnit iu) {
        this.getModel().addInstallableUnit(iu);
    }

    @Override
    public boolean hasInstallableUnits() {
        return this.getModel().hasInstallableUnits();
    }

    @Override
    public List getInstallableUnits() {
        return this.getModel().getInstallableUnits();
    }

    @Override
    public Map getPropertyKeys() {
        return this.getModel().getPropertyKeys();
    }

    @Override
    public List getProblemsResolvedList() {
        return this.getModel().getProblemsResolvedList();
    }

    @Override
    public void addProblemsResolved(IProblemsResolved resolves) {
        this.getModel().addProblemsResolved(resolves);
    }

    @Override
    public IBuilderData[] getBuilderData() {
        return this.getModel().getBuilderData();
    }

    @Override
    public void addBuilderData(IBuilderData data) {
        this.getModel().addBuilderData(data);
    }

    @Override
    public boolean hasModelAttached() {
        return this.getContentElementOrNull() != null;
    }

    @Override
    public boolean isResolved() {
        return this.getModel().isResolved();
    }
}

