/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.internal;

import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IProblemsResolved;
import com.ibm.cic.common.core.model.internal.BaseUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.osgi.framework.Version;

public abstract class OfferingOrFix
extends BaseUnit
implements IOfferingOrFix {
    private IIdentity assemblyId;
    private Version assemblyVersion;
    private IAssembly assembly;
    private ArrayList installableUnits;
    private Properties propertyKeys;
    private ArrayList resolves;

    public OfferingOrFix(IIdentity id, Version version) {
        super(id, version);
    }

    @Override
    public IAssembly getAssembly() {
        return this.assembly;
    }

    @Override
    public void setAssembly(IAssembly assembly) {
        this.assembly = assembly;
    }

    @Override
    public IIdentity getAssemblyId() {
        return this.assembly != null ? this.assembly.getIdentity() : this.assemblyId;
    }

    @Override
    public void setAssemblyId(IIdentity assemblyId) {
        this.assemblyId = assemblyId;
    }

    @Override
    public Version getAssemblyVersion() {
        return this.assembly != null ? this.assembly.getVersion() : this.assemblyVersion;
    }

    @Override
    public void setAssemblyVersion(Version assemblyVersion) {
        this.assemblyVersion = assemblyVersion;
    }

    @Override
    public void addInstallableUnit(IInstallableUnit iu) {
        assert (!this.getChildren().contains(iu));
        this.getChildren().add(iu);
    }

    @Override
    public boolean hasInstallableUnits() {
        return this.hasChildren();
    }

    @Override
    public List getInstallableUnits() {
        return this.getChildren();
    }

    @Override
    public boolean hasChildren() {
        return this.installableUnits != null;
    }

    @Override
    public void setChildrenCount(int count) {
        assert (count > 0);
        if (!this.hasChildren()) {
            this.installableUnits = new ArrayList(count);
        } else {
            this.installableUnits.ensureCapacity(count);
        }
    }

    @Override
    public List getChildren() {
        if (this.installableUnits == null) {
            this.installableUnits = new ArrayList(4);
        }
        return this.installableUnits;
    }

    @Override
    public Map getPropertyKeys() {
        if (this.propertyKeys == null) {
            this.propertyKeys = new Properties();
        }
        return this.propertyKeys;
    }

    @Override
    public List getProblemsResolvedList() {
        if (this.resolves == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.resolves);
    }

    public void setResolvesCount(int count) {
        assert (count >= 0);
        if (this.resolves == null) {
            this.resolves = new ArrayList(count);
        } else {
            this.resolves.ensureCapacity(count);
        }
    }

    @Override
    public void addProblemsResolved(IProblemsResolved resolved) {
        if (this.resolves == null) {
            this.resolves = new ArrayList();
        }
        this.resolves.add(resolved);
    }
}

