/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.internal;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.model.FeatureKind;
import com.ibm.cic.common.core.model.IContentSelector;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFeatureGroup;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IllegalFeatureStateException;
import com.ibm.cic.common.core.model.Information;
import com.ibm.cic.common.core.model.internal.AbstractFeatureBase;
import com.ibm.cic.common.core.model.internal.Messages;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.logging.Logger;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Plugin;

public class Feature
extends AbstractFeatureBase
implements IFeature {
    private static final IFeature[] NO_FEATURES = new IFeature[0];
    private static final Logger log = Logger.getLogger(Feature.class, (Plugin)ComIbmCicCommonCorePlugin.getDefault());
    private int state = 0;
    private final IIdentity id;
    private IContentSelector selector;
    private IIdentity selectorIdentity;
    private List requires;
    private List dependents;

    public Feature(IIdentity id) {
        this.id = id;
        this.setKind(FeatureKind.OPTIONAL_NOT_SELECTED);
        this.requires = Collections.EMPTY_LIST;
        this.dependents = Collections.EMPTY_LIST;
    }

    @Override
    public Information getInformation() {
        Information info = super.getInformation();
        if (info == null) {
            return new Information(this.id.getId());
        }
        return info;
    }

    public boolean equals(Object obj) {
        IFeature that;
        if (obj == this) {
            return true;
        }
        return obj instanceof IFeature && this.id.equals((that = (IFeature)obj).getIdentity());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public void setState(int state) {
        if (this.state < state) {
            this.state = state;
        }
    }

    @Override
    public boolean hasState(int theState) {
        return this.state == theState;
    }

    @Override
    public IIdentity getIdentity() {
        return this.id;
    }

    @Override
    public IContentSelector getSelector() {
        return this.selector;
    }

    @Override
    public void setSelector(IContentSelector selector) {
        this.selector = selector;
        if (selector != null) {
            this.selectorIdentity = selector.getIdentity();
        }
    }

    @Override
    public IIdentity getSelectorIdentity() {
        return this.selectorIdentity;
    }

    @Override
    public void setSelectorIdentity(IIdentity selectorIdentity) {
        this.selectorIdentity = selectorIdentity;
    }

    @Override
    public IFeature[] getRequiredFeatures() throws IllegalFeatureStateException {
        if (this.state < 1) {
            throw new IllegalFeatureStateException(Messages.Feature_RelativesNotYetComputed);
        }
        return this.requires.toArray(NO_FEATURES);
    }

    @Override
    public IFeature[] getDependentFeatures() throws IllegalFeatureStateException {
        if (this.state < 1) {
            throw new IllegalFeatureStateException(Messages.Feature_RelativesNotYetComputed);
        }
        return this.dependents.toArray(NO_FEATURES);
    }

    @Override
    public void addRequired(IFeature feature) {
        this.requires = this.addRelated(this.requires, feature);
    }

    @Override
    public void addDependent(IFeature feature) {
        this.dependents = this.addRelated(this.dependents, feature);
    }

    @Override
    public void removeRequired(IFeature feature) {
        this.requires.remove(feature);
    }

    @Override
    public void removeDependent(IFeature feature) {
        this.dependents.remove(feature);
    }

    private List addRelated(List relatives, IFeature feature) {
        if (feature != null) {
            IFeatureGroup parent = this.getParent();
            if (parent.hasMutuallyExclusiveChildren() && parent.equals(feature.getParent())) {
                log.error(NLS.bind(Messages.Feature_MutuallyExclusiveFeaturesCannotBeRelated, this.getInformation(), feature.getInformation(), parent.getInformation()));
            } else {
                if (relatives == Collections.EMPTY_LIST) {
                    relatives = new LinkedList<IFeature>();
                }
                if (!relatives.contains(feature)) {
                    relatives.add(feature);
                }
            }
        }
        return relatives;
    }

    @Override
    protected String getAdditionalAttributes() {
        StringBuffer sb = new StringBuffer();
        sb.append("id='").append(this.id.getId()).append('\'');
        if (this.selectorIdentity != null) {
            sb.append(" selectionId='").append(this.selectorIdentity.getId()).append('\'');
        }
        return sb.toString();
    }

    @Override
    protected String getElementImage() {
        return "feature";
    }
}

