/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.adapterdata.impl;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class MapToLegacyKeyUtil {
    private static final String TEMP_LEGACY_ARTIFACT_PROTOCOL = "artifact:";

    public static ColonArtifactKeyInfo parseForColonArtifactKey(String key) {
        if (key != null && key.startsWith(TEMP_LEGACY_ARTIFACT_PROTOCOL)) {
            ColonArtifactKeyInfo info = new ColonArtifactKeyInfo();
            String s = key.substring(TEMP_LEGACY_ARTIFACT_PROTOCOL.length() + 1);
            int start = 0;
            int end = s.indexOf("/");
            String[] a = new String[3];
            int i = 0;
            while (i < 3 && end > 0) {
                a[i] = s.substring(start, end);
                start = end + 1;
                end = s.indexOf("/", start);
                ++i;
            }
            if (start < s.length() - 1) {
                a[i] = s.substring(start);
            }
            info.setQualns(a[0]);
            info.setIdentity(a[1]);
            info.setVersion(a[2]);
            return info;
        }
        return null;
    }

    public static String createKeyString(ColonArtifactKeyInfo key) {
        return key.toString();
    }

    public static IPath parseForNonColonArtifactKey(String key) {
        if (key == null) {
            return Path.EMPTY;
        }
        if (!key.startsWith(TEMP_LEGACY_ARTIFACT_PROTOCOL)) {
            return new Path(key);
        }
        return null;
    }

    public static class ColonArtifactKeyInfo {
        private String qualns;
        private String id;
        private String version;

        public String getIdentity() {
            return this.id;
        }

        public void setIdentity(String identity) {
            this.id = identity;
        }

        public String getQualns() {
            return this.qualns;
        }

        public void setQualns(String qualns) {
            this.qualns = qualns;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String toString() {
            String k = "artifact:/" + this.qualns + '/' + this.id + '/' + this.version;
            return k;
        }
    }
}

