/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.adapterdata.impl;

import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.adapterdata.ArtifactTypeInfo;
import com.ibm.cic.common.core.model.adapterdata.ArtifactTypesUtil;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.core.model.adapterdata.IArtifactTypeKeyMapper;
import com.ibm.cic.common.core.model.adapterdata.impl.AdapterDataParseUtil;
import com.ibm.cic.common.core.model.adapterdata.impl.ArtifactKey;
import com.ibm.cic.common.core.model.internal.Messages;
import com.ibm.cic.common.core.model.validation.ArtifactCheck;
import com.ibm.cic.common.core.utils.NLS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Version;

public abstract class ArtifactReferenceParseUtil {
    private ArtifactReferenceParseUtil() {
    }

    public static class ArtifactRefParser
    extends AdapterDataParseUtil.StandardNamedArgumentParser {
        static final Set requiredSet = new LinkedHashSet<String>(Arrays.asList("type", "id", "version"));
        private SimpleIdentity resultIdOnly;
        private IArtifactKey resultKey;

        public ArtifactRefParser() {
            super(',', '=');
        }

        @Override
        public void parse(String arg0) throws AdapterDataParseUtil.AdapterDataParseException {
            this.setResultIdOnly(null);
            this.setResultKey(null);
            super.parse(arg0);
            Map result = this.getResult();
            if (result.size() == 1) {
                if (!result.containsKey("id")) {
                    throw new AdapterDataParseUtil.AdapterDataParseException(NLS.bind(Messages.ArtifactReferenceParseUtil_missingAttribute, (Object)"id"));
                }
                String idStr = this.getValue("id");
                this.checkValidId(idStr);
                this.setResultIdOnly(new SimpleIdentity(idStr));
            } else {
                this.checkRequired(requiredSet);
                IArtifactKey key = this.determineKey();
                this.setResultKey(key);
            }
        }

        public String unparse(IArtifactKey key) throws ArtifactTypesUtil.ArtifactTypeRegistryException {
            IArtifactTypeKeyMapper mapper = ArtifactTypesUtil.getArtifactTypeKeyMapper(key.getNamespace(), key.getQualifier());
            Map map = mapper.makeTypeArgsFromKey(key);
            return this.unparse(map);
        }

        private void setResultKey(IArtifactKey key) {
            this.resultKey = key;
        }

        private void setResultIdOnly(SimpleIdentity simpleIdentity) {
            this.resultIdOnly = simpleIdentity;
        }

        public IIdentity getResultIdOnly() {
            return this.resultIdOnly;
        }

        public IArtifactKey getResultKey() {
            return this.resultKey;
        }

        private IArtifactKey determineKey() throws AdapterDataParseUtil.AdapterDataParseException {
            Map result = this.getResult();
            String type = this.getValue("type");
            String idStr = this.getValue("id");
            this.checkValidId(idStr);
            SimpleIdentity id = new SimpleIdentity(idStr);
            String versionStr = this.getValue("version");
            Version version = null;
            try {
                version = new Version(versionStr);
            }
            catch (IllegalArgumentException e) {
                throw new AdapterDataParseUtil.AdapterDataParseException(NLS.bind(Messages.ArtifactReferenceParseUtil_badVersion, (Object)e.getLocalizedMessage()));
            }
            LinkedHashMap<String, String> typeSpecificArgs = new LinkedHashMap<String, String>(result.size() - 3);
            for (String name : result.keySet()) {
                if (requiredSet.contains(name)) continue;
                typeSpecificArgs.put(name, this.getValue(name));
            }
            IArtifactTypeKeyMapper mapper = null;
            try {
                mapper = ArtifactTypesUtil.getArtifactTypeKeyMapperForType(type);
            }
            catch (ArtifactTypesUtil.ArtifactTypeRegistryException e) {
                String msg = NLS.bind(Messages.ArtifactReferenceParseUtil_typeNotSupported, type, ArtifactTypesUtil.getArtifactTypes(), e.getLocalizedMessage());
                throw new AdapterDataParseUtil.AdapterDataParseException(msg);
            }
            try {
                return mapper.makeKeyFromTypeArgs(type, id, version, typeSpecificArgs);
            }
            catch (IllegalArgumentException e) {
                throw new AdapterDataParseUtil.AdapterDataParseException(e.getLocalizedMessage());
            }
        }

        private void checkValidId(String idStr) throws AdapterDataParseUtil.AdapterDataParseException {
            String invalidReason = ArtifactCheck.getInvalidIdReason(idStr);
            if (invalidReason != null) {
                throw new AdapterDataParseUtil.AdapterDataParseException(NLS.bind(Messages.ArtifactReferenceParseUtil_badIdValue, (Object)ArtifactCheck.VALID_ID_TIP));
            }
        }

        private String getValue(String key) {
            return (String)this.getResult().get(key);
        }

        private void checkRequired(Set requiredNames) throws AdapterDataParseUtil.AdapterDataParseException {
            Map result = this.getResult();
            ArrayList<String> missing = null;
            for (String name : requiredNames) {
                if (result.containsKey(name)) continue;
                if (missing == null) {
                    missing = new ArrayList<String>();
                }
                missing.add(name);
            }
            if (missing != null) {
                throw new AdapterDataParseUtil.AdapterDataParseException(NLS.bind(Messages.ArtifactReferenceParseUtil_missingArguments, missing));
            }
        }
    }

    public static abstract class ArtifactVariableEval {
        public static final String ARTIFACT_VAR = "artifact";
        private String variableArg;

        public IArtifact getReferencedArtifact(String varArg) throws ArtifactVariableEvalException {
            this.variableArg = varArg;
            if (this.variableArg == null) {
                throw new ArtifactVariableEvalException(NLS.bind(Messages.ArtifactReferenceParseUtil_missingArgumentsGiveExamples, this.getVariableMsg(), this.getExampleSimpleIdSyntax(), this.getExampleFullSyntax()));
            }
            ArtifactRefParser parser = new ArtifactRefParser();
            try {
                parser.parse(this.variableArg);
            }
            catch (AdapterDataParseUtil.AdapterDataParseException e) {
                String msg = null;
                msg = e.isUserNeedsBasicHelp() ? NLS.bind(Messages.ArtifactReferenceParseUtil_badExpressionGiveExamples, this.getVariableMsg(), e.getLocalizedMessage(), this.getExampleSimpleIdSyntax(), this.getExampleFullSyntax()) : NLS.bind(Messages.ArtifactReferenceParseUtil_badExpression, (Object)this.getVariableMsg(), (Object)e.getLocalizedMessage());
                throw new ArtifactVariableEvalException(msg);
            }
            IIdentity idOnly = parser.getResultIdOnly();
            IArtifact artifact = null;
            artifact = idOnly != null ? this.findMatchingArtifactById(idOnly) : this.findMatchingArtifactByKey(parser.getResultKey());
            assert (artifact != null);
            this.verifyCanAccess(artifact);
            return artifact;
        }

        private String getExampleSimpleIdSyntax() {
            return AdapterDataParseUtil.getSubstitutionExpression(ARTIFACT_VAR, NLS.bind(Messages.ArtifactReferenceParseUtil_sampleIdOnlySyntax, (Object)"id"));
        }

        private String getExampleFullSyntax() {
            Collection validTypes = ArtifactTypesUtil.getArtifactTypes();
            return AdapterDataParseUtil.getSubstitutionExpression(ARTIFACT_VAR, NLS.bind(Messages.ArtifactReferenceParseUtil_sampleFullSyntax, "type", validTypes, "id", "version", "ext"));
        }

        protected IArtifact getSingleMatch(List matches) throws ArtifactVariableEvalException {
            if (matches.size() == 0) {
                throw new ArtifactVariableEvalException(NLS.bind(Messages.ArtifactReferenceParseUtil_expressionColonSingleMatchExplanation, (Object)this.getVariableMsg(), (Object)this.getNoMatchExplanation()));
            }
            if (matches.size() > 1) {
                throw new ArtifactVariableEvalException(NLS.bind(Messages.ArtifactReferenceParseUtil_expressionAmbiguousMultipleMatchesExpanation, (Object)this.getVariableMsg(), (Object)this.getMultipleMatchesExplanation(matches)));
            }
            return (IArtifact)matches.get(0);
        }

        protected String getVariableMsg() {
            return AdapterDataParseUtil.getSubstitutionExpression(ARTIFACT_VAR, this.variableArg);
        }

        protected abstract void verifyCanAccess(IArtifact var1) throws ArtifactVariableEvalException;

        protected abstract String getNoMatchExplanation();

        protected abstract String getMultipleMatchesExplanation(List var1);

        protected IArtifact findMatchingArtifactById(IIdentity wantedId) throws ArtifactVariableEvalException {
            ArrayList<IArtifact> matches = new ArrayList<IArtifact>();
            Collection artifacts = this.getArtifacts();
            for (IArtifact artifact : artifacts) {
                if (!wantedId.equals(artifact.getKey().getId())) continue;
                matches.add(artifact);
            }
            return this.getSingleMatch(matches);
        }

        protected abstract Collection getArtifacts();

        private IArtifact findMatchingArtifactByKey(IArtifactKey wanted) throws ArtifactVariableEvalException {
            ArrayList<IArtifact> matches = new ArrayList<IArtifact>();
            Collection artifacts = this.getArtifacts();
            for (IArtifact artifact : artifacts) {
                if (!wanted.equals(artifact.getKey())) continue;
                matches.add(artifact);
            }
            return this.getSingleMatch(matches);
        }
    }

    public static class ArtifactVariableEvalException
    extends Exception {
        public ArtifactVariableEvalException(String msg) {
            super(msg);
        }
    }

    public static class ArtifactsTypeWithExtKeyMapper
    extends BaseArtifactsTypeKeyMapper {
        private final String defaultExtension;
        private static final String EXT = "ext";

        public ArtifactsTypeWithExtKeyMapper(ArtifactTypeInfo ati, String defaultExtension) {
            super(ati);
            this.defaultExtension = defaultExtension;
        }

        @Override
        public IArtifactKey makeKeyFromTypeArgs(String type, IIdentity id, Version version, Map typeSpecificArgs) {
            ArtifactTypeInfo ati = this.getArtifactTypeInfo();
            assert (ati != null);
            String ext = null;
            if (typeSpecificArgs.size() == 0) {
                ext = this.defaultExtension;
            } else if (typeSpecificArgs.containsKey(EXT)) {
                if (typeSpecificArgs.size() > 1) {
                    throw new IllegalArgumentException(NLS.bind(Messages.ArtifactReferenceParseUtil_expectingTypeSpecificParameterOnlyInsteadOf, (Object)EXT, (Object)typeSpecificArgs));
                }
                ext = (String)typeSpecificArgs.get(EXT);
            } else {
                throw new IllegalArgumentException(NLS.bind(Messages.ArtifactReferenceParseUtil_expectingTypeSpecificParameterInsteadOf, (Object)EXT, (Object)typeSpecificArgs));
            }
            return new ArtifactKey((IPath)new Path(ext), ati.getKeyNamespace(), ati.getKeyQualifier(), id, version);
        }

        @Override
        public Map makeTypeArgsFromKey(IArtifactKey key) {
            LinkedHashMap<String, String> refArgs = new LinkedHashMap<String, String>(3);
            ArtifactTypeInfo ati = this.getArtifactTypeInfo();
            refArgs.put("type", ati.getType());
            refArgs.put("id", key.getId().getId());
            refArgs.put("version", key.getVersion().toString());
            refArgs.put(EXT, key.getPath().toString());
            return Collections.unmodifiableMap(refArgs);
        }
    }

    public static class BaseArtifactsTypeKeyMapper
    implements IArtifactTypeKeyMapper {
        private final ArtifactTypeInfo ati;

        public BaseArtifactsTypeKeyMapper(ArtifactTypeInfo ati) {
            this.ati = ati;
        }

        @Override
        public ArtifactTypeInfo getArtifactTypeInfo() {
            return this.ati;
        }

        @Override
        public IArtifactKey makeKeyFromTypeArgs(String type, IIdentity id, Version version, Map typeSpecificArgs) {
            assert (this.ati != null);
            if (typeSpecificArgs.size() != 0) {
                throw new IllegalArgumentException(NLS.bind(Messages.ArtifactReferenceParseUtil_unknownArgumentsForType, (Object)type, (Object)typeSpecificArgs));
            }
            return new ArtifactKey((IPath)Path.EMPTY, this.ati.getKeyNamespace(), this.ati.getKeyQualifier(), id, version);
        }

        @Override
        public Map makeTypeArgsFromKey(IArtifactKey key) {
            LinkedHashMap<String, String> refArgs = new LinkedHashMap<String, String>(3);
            refArgs.put("type", this.ati.getType());
            refArgs.put("id", key.getId().getId());
            refArgs.put("version", key.getVersion().toString());
            return Collections.unmodifiableMap(refArgs);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("artifact mapper for type=");
            sb.append(this.ati.getType());
            sb.append(" key.namespace=").append(this.ati.getKeyNamespace());
            sb.append(" key.qualifier=").append(this.ati.getKeyQualifier());
            return sb.toString();
        }
    }
}

