/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.adapterdata.impl;

import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.core.model.adapterdata.impl.ArtifactKeyUtil;
import org.eclipse.core.runtime.IPath;
import org.osgi.framework.Version;

public class ArtifactKey
implements IArtifactKey {
    static final int NO_SEGMENTS = 5;
    private static final char SEP_CHAR = ',';
    private final IPath path;
    private final String namespace;
    private final String qualifier;
    private final IIdentity id;
    private final Version version;

    public ArtifactKey(IPath path, String namespace, String qualifier, IIdentity id, Version version) {
        if (namespace.indexOf(44) != -1) {
            throw new IllegalArgumentException("comma not allowed in namespace");
        }
        if (qualifier.indexOf(44) != -1) {
            throw new IllegalArgumentException("comma not allowed in qualifier");
        }
        if (id.getId().indexOf(44) != -1) {
            throw new IllegalArgumentException("comma not allowed in id");
        }
        this.path = path;
        this.namespace = namespace;
        this.qualifier = qualifier;
        this.id = id;
        this.version = version;
    }

    public ArtifactKey(IArtifactKey rhs) {
        this(rhs.getPath(), rhs.getNamespace(), rhs.getQualifier(), rhs.getId(), rhs.getVersion());
    }

    @Override
    public IPath getPath() {
        return this.path;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getQualifier() {
        return this.qualifier;
    }

    @Override
    public IIdentity getId() {
        return this.id;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public int hashCode() {
        int hash = this.id.hashCode();
        hash = 17 * hash + this.version.hashCode();
        hash = 17 * hash + this.namespace.hashCode();
        hash = 17 * hash + this.qualifier.hashCode();
        hash = 17 * hash + this.path.hashCode();
        return hash;
    }

    public String toString() {
        return "ArtifactKey=" + this.toUniqueString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ArtifactKey)) {
            return false;
        }
        ArtifactKey ak = (ArtifactKey)obj;
        return ak.id.equals(this.id) && ak.version.equals((Object)this.version) && ak.namespace.equals(this.namespace) && ak.qualifier.equals(this.qualifier) && ak.path.equals((Object)this.path);
    }

    @Override
    public String toUniqueString() {
        return ArtifactKeyUtil.toCombinedString(this);
    }
}

