/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.adapterdata;

import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IHasAdapterDataChildren;
import com.ibm.cic.common.core.utils.UnsupportedOperationException;
import com.ibm.cic.common.core.utils.XMLUtil;
import com.ibm.cic.common.downloads.ContentInfoUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class CommonAdapterData
implements IHasAdapterDataChildren,
Cloneable {
    private static final String NO_INDENT = "";
    protected static final String NO_ELEMENT_TEXT = "";
    protected static final CommonAdapterData[] NO_CHILDREN = new CommonAdapterData[0];
    private int lineNumber;

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String toString() {
        return this.toXML(false);
    }

    public String toXML(boolean forInconsistentIuCheck) {
        StringBuffer sb = new StringBuffer();
        this.toXML(sb, "", forInconsistentIuCheck);
        return sb.toString();
    }

    public IArtifact getArtifact() {
        return null;
    }

    public void setArtifact(IArtifact artifact) {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.getElementName();
    }

    public abstract String getElementName();

    protected NameValuePairs getAttrNameValuePairs() {
        return NameValuePairs.NONE;
    }

    protected String getElementText() {
        return "";
    }

    @Override
    public CommonAdapterData[] getChildren() {
        return NO_CHILDREN;
    }

    private void toXML(StringBuffer sb, String indent, boolean forInconsistentIuCheck) {
        String elemName = this.getElementName();
        NameValuePairs nameValuePairs = this.getAttrNameValuePairs();
        XMLUtil.unterminatedElement(elemName, nameValuePairs.toArray(), sb, indent);
        IArtifact artifact = this.getArtifact();
        if (artifact != null) {
            ContentInfoUtil.appendContentInfoXML(sb, artifact.getContentInfo(), forInconsistentIuCheck);
        }
        CommonAdapterData[] children = this.getChildren();
        String elemText = this.getElementText();
        if (children.length == 0 && elemText.length() == 0) {
            sb.append("/>");
            return;
        }
        sb.append('>');
        sb.append(XMLUtil.escape(elemText));
        String newIndent = String.valueOf(indent) + "  ";
        CommonAdapterData[] commonAdapterDataArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            CommonAdapterData child = commonAdapterDataArray[n2];
            sb.append('\n');
            child.toXML(sb, newIndent, forInconsistentIuCheck);
            ++n2;
        }
        if (children.length != 0) {
            sb.append('\n').append(indent);
        }
        sb.append("</").append(elemName).append('>');
    }

    public Object clone() throws CloneNotSupportedException {
        CommonAdapterData data = (CommonAdapterData)super.clone();
        return data;
    }

    public boolean useProfileLocaleForNLProperty() {
        return false;
    }

    protected static class NameValuePairs {
        public static final NameValuePairs NONE = new NameValuePairs();
        private final List pairs = new ArrayList(8);

        public NameValuePairs() {
        }

        public NameValuePairs(String name, Object value) {
            this();
            this.add(name, value);
        }

        public NameValuePairs add(String name, Object value) {
            if (value != null) {
                this.pairs.add(name);
                this.pairs.add(value.toString());
            }
            return this;
        }

        public NameValuePairs add(String name, Object value, Object defaultValue) {
            return this.add(name, value != null ? value : defaultValue);
        }

        public NameValuePairs add(String name, boolean value) {
            return this.add(name, Boolean.toString(value));
        }

        public NameValuePairs addIf(boolean condition, String name, Object value) {
            if (condition) {
                this.add(name, value);
            }
            return this;
        }

        public NameValuePairs addIfTrue(String name, boolean value) {
            return this.addIf(value, name, Boolean.toString(value));
        }

        public NameValuePairs addIfFalse(String name, boolean value) {
            return this.addIf(!value, name, Boolean.toString(value));
        }

        public String[] toArray() {
            return this.pairs.toArray(new String[this.pairs.size()]);
        }
    }
}

