/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model;

import com.ibm.cic.common.core.model.internal.EnumMapper;

public class Phases {
    public static final int COLLECT = 0;
    public static final int PRE_INSTALL_CONFIGURE = 10;
    public static final int PRE_INSTALL = 20;
    public static final int INSTALL = 21;
    public static final int POST_INSTALL = 22;
    public static final int POST_INSTALL_CONFIGURE = 30;
    public static final int PRE_UNINSTALL_CONFIGURE = 40;
    public static final int PRE_UNINSTALL = 50;
    public static final int UNINSTALL = 51;
    public static final int POST_UNINSTALL = 52;
    public static final int POST_UNINSTALL_CONFIGURE = 60;
    public static final int UNKNOWN = -1;
    public static final int LAST_PHASE = 63;
    private static final EnumMapper mapper = new EnumMapper(63, Phases.class);
    private static final int[] installationPhaseOrder = new int[]{10, 20, 21, 22, 30};
    private static final int[] uninstallationPhaseOrder = new int[]{40, 50, 51, 52, 60};

    public static int[] getAllPhases() {
        return mapper.getAllEnums();
    }

    public static int[] getAllInstallPhases() {
        return installationPhaseOrder;
    }

    public static int[] getAllUninstallPhases() {
        return uninstallationPhaseOrder;
    }

    public static int nameToPhase(String s) {
        return mapper.nameToEnum(s);
    }

    public static String phaseToName(int phase) {
        return mapper.enumToName(phase);
    }

    public static boolean isInstallationPhase(int phase) {
        return phase == 0 || Phases.isInPhases(phase, installationPhaseOrder);
    }

    public static boolean isUninstallationPhase(int phase) {
        return Phases.isInPhases(phase, uninstallationPhaseOrder);
    }

    public static int getUndoPhase(int phase) {
        assert (installationPhaseOrder.length == uninstallationPhaseOrder.length);
        int last = installationPhaseOrder.length - 1;
        int i = 0;
        while (i < installationPhaseOrder.length) {
            if (phase == installationPhaseOrder[i]) {
                return uninstallationPhaseOrder[last - i];
            }
            ++i;
        }
        i = 0;
        while (i < uninstallationPhaseOrder.length) {
            if (phase == uninstallationPhaseOrder[i]) {
                return installationPhaseOrder[last - i];
            }
            ++i;
        }
        return -1;
    }

    private Phases() {
    }

    private static boolean isInPhases(int phase, int[] phases) {
        int[] nArray = phases;
        int n = phases.length;
        int n2 = 0;
        while (n2 < n) {
            int phase2 = nArray[n2];
            if (phase == phase2) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

