/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.ICicResolver;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.model.internal.CICParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IStatus;
import org.osgi.framework.BundleContext;
import org.xml.sax.SAXException;

public class Parser {
    private final CICParser parser;

    public Parser() {
        this(ComIbmCicCommonCorePlugin.getBundleContext());
    }

    public Parser(BundleContext context) {
        this.parser = new CICParser(context);
    }

    public IStatus getStatus() {
        return this.parser == null ? null : this.parser.getStatus();
    }

    public ICicResolver parseAll(File dir) {
        return this.parser.parseAll(dir);
    }

    public ICicResolver parseJar(File jarFile) throws IOException {
        return this.parser.parseJar(jarFile);
    }

    public IContent parse(File file) throws SAXException, IOException, ParserConfigurationException {
        return this.parse(new FileInputStream(file), file.getAbsolutePath());
    }

    public IContent parse(InputStream in, String filePath) throws SAXException, IOException, ParserConfigurationException {
        return this.parser.parse(in, filePath);
    }

    public IOffering parseOffering(InputStream in, String filePath) throws SAXException, IOException, ParserConfigurationException {
        return (IOffering)this.parse(in, filePath);
    }

    public IFix parseFix(InputStream in, String filePath) throws SAXException, IOException, ParserConfigurationException {
        return (IFix)this.parse(in, filePath);
    }

    public IAssembly parseAssembly(InputStream in, String filePath) throws SAXException, IOException, ParserConfigurationException {
        return (IAssembly)this.parse(in, filePath);
    }

    public IShareableUnit parseShareableUnit(InputStream in, String filePath) throws SAXException, IOException, ParserConfigurationException {
        return (IShareableUnit)this.parse(in, filePath);
    }

    public ISuFragment parseSuFragment(InputStream in, String filePath) throws SAXException, IOException, ParserConfigurationException {
        return (ISuFragment)this.parse(in, filePath);
    }

    public IInstallableUnit parseInstallableUnit(InputStream in, String filePath) throws SAXException, IOException, ParserConfigurationException {
        return (IInstallableUnit)this.parse(in, filePath);
    }

    public void setParseBuildData(boolean value) {
        this.parser.setIncludeBuildData(value);
    }
}

