/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.downloads;

public class LastRates {
    private final long[] rates;
    private int head;
    private int count;

    public LastRates(int n) {
        this.rates = new long[n];
        this.init();
    }

    private void init() {
        this.count = 0;
        this.head = 0;
        int i = 0;
        while (i < this.rates.length) {
            this.rates[i] = -1L;
            ++i;
        }
    }

    public long avg() {
        return this.avg(this.rates.length);
    }

    public long avgMaxData() {
        return this.avg(this.count);
    }

    public long avg(int counts) {
        if (counts > this.count) {
            return -1L;
        }
        long sum = 0L;
        int n = 0;
        int b = this.head - counts;
        if (b < 0) {
            b += this.rates.length;
        }
        int c = b;
        while (c < b + counts) {
            int i = c % this.rates.length;
            long rate = this.rates[i];
            if (rate != -1L) {
                sum += rate;
                ++n;
            }
            ++c;
        }
        if (n == 0) {
            return -1L;
        }
        return sum / (long)n;
    }

    public void add(long rate) {
        if (rate == -1L) {
            this.init();
            return;
        }
        this.rates[this.head] = rate;
        if (this.count < this.rates.length) {
            ++this.count;
        }
        this.head = (this.head + 1) % this.rates.length;
    }
}

