/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.downloads;

import com.ibm.cic.common.core.internal.downloads.HostInfoCredentials;
import java.net.URL;

public class CredentialStoreEntry {
    private String protocol;
    private String host;
    private int port;
    private String realm;
    private String scheme;
    private ProxyType proxyType;

    public CredentialStoreEntry() {
    }

    public CredentialStoreEntry(String protocol, String host, int port, String realm, String scheme) {
        this(protocol, host, port, realm, scheme, ProxyType.NO_PROXY);
    }

    public CredentialStoreEntry(String protocol, String host, int port, String realm, String scheme, ProxyType type) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.realm = realm;
        this.scheme = scheme;
        this.proxyType = type;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isProxy() {
        return !this.proxyType.equals(ProxyType.NO_PROXY);
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public ProxyType getProxyType() {
        return this.proxyType;
    }

    public void setProxyType(ProxyType proxyType) {
        this.proxyType = proxyType;
    }

    public static CredentialStoreEntry create(URL url, String realm, String scheme, boolean isProxy) {
        CredentialStoreEntry entry = new CredentialStoreEntry(url.getProtocol(), url.getHost(), url.getPort(), realm, scheme);
        if (HostInfoCredentials.isSocksProxyRealm(realm)) {
            entry.setProxyType(ProxyType.SOCKS_PROXY);
        } else if (isProxy) {
            entry.setProxyType(ProxyType.HTTP_PROXY);
        }
        return entry;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CredentialStoreEntry)) {
            return false;
        }
        CredentialStoreEntry entry = (CredentialStoreEntry)o;
        return this.protocol.equals(entry.getProtocol()) && this.host.equals(entry.getHost()) && this.realm.equals(entry.getRealm()) && this.scheme.equalsIgnoreCase(entry.getScheme()) && this.proxyType.equals(entry.getProxyType()) && this.port == entry.getPort();
    }

    public int hashCode() {
        return 17 * this.protocol.hashCode() + 17 * this.host.hashCode() + this.port + 17 * this.realm.hashCode() + 17 * this.scheme.hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.protocol);
        buf.append(",");
        buf.append(this.host);
        buf.append(",");
        buf.append(this.port);
        buf.append(",");
        buf.append(this.realm);
        buf.append(",");
        buf.append(this.scheme);
        buf.append(",");
        buf.append(this.proxyType);
        return buf.toString();
    }

    public static final class ProxyType {
        private final String name;
        public static final ProxyType NO_PROXY = new ProxyType("No Proxy");
        public static final ProxyType SOCKS_PROXY = new ProxyType("SOCKS Proxy");
        public static final ProxyType HTTP_PROXY = new ProxyType("HTTP Proxy");

        private ProxyType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ProxyType)) {
                return false;
            }
            return this == o;
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            return 17 * this.name.hashCode();
        }
    }
}

