/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.artifactrepo;

import com.ibm.cic.common.core.downloads.DownloadContextThreadLocalInheritedAndGlobal;
import com.ibm.cic.common.downloads.AbstractDownloadListener;
import com.ibm.cic.common.downloads.DownloadEvents;
import com.ibm.cic.common.downloads.IDownloadListener;
import com.ibm.cic.common.logging.Logger;

public class DownloadAccessMonitor {
    private static final Logger log = Logger.getLogger(DownloadAccessMonitor.class);
    private IDownloadListener.Access faccess = null;
    private IDownloadListener.Access previousAccess = null;
    private long timePreviousAccessEnded = -1L;
    private boolean previousMayResume = false;
    private final DownloadListener listener;
    private final StartAccessCallback startAccessCB;

    public DownloadAccessMonitor(StartAccessCallback startAccessCB) {
        this.startAccessCB = startAccessCB;
        this.listener = new DownloadListener();
        DownloadEvents.getDownloadEvents(DownloadContextThreadLocalInheritedAndGlobal.getThreadContext()).addListener(this.listener);
    }

    public void close() {
        DownloadEvents.getDownloadEvents(DownloadContextThreadLocalInheritedAndGlobal.getThreadContext()).removeListener(this.listener);
    }

    public IDownloadListener.Access getAccess(long msFadeTime, boolean returnNonResumeable) {
        if (this.faccess != null) {
            return this.faccess;
        }
        if (this.previousAccess == null || msFadeTime == 0L) {
            return null;
        }
        if (!returnNonResumeable && !this.previousMayResume) {
            return null;
        }
        long msCurrent = System.currentTimeMillis();
        if (this.timePreviousAccessEnded + msFadeTime > msCurrent) {
            return this.previousAccess;
        }
        return null;
    }

    private void startAccess(IDownloadListener.Access access) {
        if (access != null) {
            log.debug("previous access not properly cleared", access);
        }
        this.faccess = access;
        this.previousAccess = null;
        this.previousMayResume = false;
        this.timePreviousAccessEnded = -1L;
        if (this.startAccessCB != null) {
            this.startAccessCB.startAccess(access);
        }
    }

    private void endAccess(IDownloadListener.Access access, boolean mayResume) {
        this.previousAccess = access;
        this.previousMayResume = mayResume;
        this.timePreviousAccessEnded = System.currentTimeMillis();
        this.faccess = null;
    }

    class DownloadListener
    extends AbstractDownloadListener {
        DownloadListener() {
        }

        @Override
        public void beforeSendRequest(IDownloadListener.Access access) {
            DownloadAccessMonitor.this.startAccess(access);
        }

        @Override
        public void sendRequestException(IDownloadListener.Access access, Exception e) {
            DownloadAccessMonitor.this.endAccess(access, true);
        }

        @Override
        public void receivedResponse(IDownloadListener.Access access, Object received) {
            DownloadAccessMonitor.this.endAccess(access, true);
        }

        @Override
        public void closeReadingStream(IDownloadListener.Access access) {
            DownloadAccessMonitor.this.endAccess(access, false);
        }

        @Override
        public void sendRequestCanceled(IDownloadListener.Access access) {
            DownloadAccessMonitor.this.endAccess(access, false);
        }

        @Override
        public void openReadingStream(IDownloadListener.Access access) {
            DownloadAccessMonitor.this.startAccess(access);
        }
    }

    public static interface StartAccessCallback {
        public void startAccess(IDownloadListener.Access var1);
    }
}

