/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.artifactrepo;

import com.ibm.cic.common.core.artifactrepo.IArtifactRepositoryAdapter;
import com.ibm.cic.common.core.artifactrepo.impl.Messages;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.utils.NLS;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class ArtifactRepositoryAdapters {
    private static final String PT_ARTIFACT_REPO_ADAPTER = "artifactRepositoryAdapter";
    private static final String PT_NAMESPACE_ATTR = "namespace";
    private static final String PT_CLASS_ATTR = "class";
    private static Map artifactRepositoryAdapters = null;

    private static void logError(String msg) {
        ComIbmCicCommonCorePlugin.log(msg);
    }

    public static Collection getAdapterNamespaces() {
        if (artifactRepositoryAdapters == null) {
            artifactRepositoryAdapters = ArtifactRepositoryAdapters.initializeExtensions(PT_ARTIFACT_REPO_ADAPTER);
        }
        return artifactRepositoryAdapters.keySet();
    }

    public static IArtifactRepositoryAdapter getAdapter(String namespace) {
        Object extension;
        if (artifactRepositoryAdapters == null) {
            artifactRepositoryAdapters = ArtifactRepositoryAdapters.initializeExtensions(PT_ARTIFACT_REPO_ADAPTER);
        }
        if ((extension = ArtifactRepositoryAdapters.getAdapterDataExtension(artifactRepositoryAdapters, namespace)) instanceof IArtifactRepositoryAdapter) {
            return (IArtifactRepositoryAdapter)extension;
        }
        if (extension != null) {
            ArtifactRepositoryAdapters.logError(NLS.bind(Messages.Util_class_for_extension_point_does_not_implement, extension.getClass(), PT_ARTIFACT_REPO_ADAPTER, "IArtifactRepositoryAdapterFactory"));
        }
        return null;
    }

    private static Object getAdapterDataExtension(Map extensions, String namespace) {
        Object obj = extensions.get(namespace);
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof IConfigurationElement)) {
            return obj;
        }
        IConfigurationElement element = (IConfigurationElement)obj;
        Object extension = null;
        try {
            extension = element.createExecutableExtension(PT_CLASS_ATTR);
        }
        catch (CoreException e) {
            ArtifactRepositoryAdapters.logError(NLS.bind(Messages.Util_failed_to_create_executable_extension, (Object)element.getAttribute(PT_CLASS_ATTR), (Object)e.getMessage()));
        }
        extensions.put(namespace, extension);
        return extension;
    }

    private static Map initializeExtensions(String extPointId) {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(ComIbmCicCommonCorePlugin.getPluginId(), extPointId);
        if (point == null) {
            return new HashMap(0);
        }
        IExtension[] extensions = point.getExtensions();
        HashMap<String, IConfigurationElement> result = new HashMap<String, IConfigurationElement>(extensions.length);
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (extPointId.equalsIgnoreCase(element.getName())) {
                    String namespace = element.getAttribute(PT_NAMESPACE_ATTR);
                    Object prev = result.get(namespace);
                    if (prev != null) {
                        ArtifactRepositoryAdapters.logError(NLS.bind(Messages.Util_more_than_one_extension_for, extPointId, namespace, prev, element));
                    }
                    result.put(namespace, element);
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }
}

