/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal;

import com.ibm.cic.common.core.internal.BoundToOfferingOrFixFactory;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.utils.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class LicenseFactory
extends BoundToOfferingOrFixFactory {
    private static final String TAG_LICENSE_TEXT = "licenseText";
    private static final String TAG_LICENSE = "license";
    private static final String TAG_LICENSE_OFFERING_BINDING = "licenseOfferingBinding";
    private static final String TAG_LICENSE_FIX_BINDING = "licenseFixBinding";
    private static final String ATT_LICENSE_ID = "licenseId";
    private static final String ATT_GROUPING = "grouping";
    private static final String ATT_PRIMARY = "primary";
    private static final String ATT_FILE = "file";
    private static final String ATT_LABEL = "label";
    private static final String ATT_LICENSE_TYPE = "licenseType";
    public static final String LICENSE_TYPE_PERMANENT = "PERMANENT";
    public static final String LICENSE_TYPE_FLOATING = "FLOATING";
    public static final String LICENSE_TYPE_TRIAL = "TRIAL";
    public static final String LICENSE_TYPE_TERM = "TERM";
    public static final String LICENSE_SUB_GROUP = "subGroup";
    private static LicenseFactory instance;

    public static LicenseFactory getInstance() {
        if (instance == null) {
            instance = new LicenseFactory();
        }
        return instance;
    }

    public License[] sortLicensesArray(License[] licenses) {
        Arrays.sort(licenses, new Comparator<License>(){

            @Override
            public int compare(License arg0, License arg1) {
                return arg0.getGrouping().compareTo(arg1.getGrouping());
            }
        });
        return licenses;
    }

    public License[] findLicenseTextFor(IOfferingOrFix offeringOrFix) {
        return this.findLicenseTextFor(offeringOrFix, LICENSE_TYPE_TRIAL);
    }

    public License[] findLicenseTextFor(IOfferingOrFix offeringOrFix, String licenseType) {
        IExtensionPoint licensePoint = Platform.getExtensionRegistry().getExtensionPoint(ComIbmCicCommonCorePlugin.getPluginId(), TAG_LICENSE_TEXT);
        IExtension[] extensions = licensePoint.getExtensions();
        SortedMap licenseBindings = this.findOfferingOrFixBindings(offeringOrFix, TAG_LICENSE_OFFERING_BINDING, TAG_LICENSE_FIX_BINDING, extensions);
        ArrayList<License> pageList = new ArrayList<License>();
        for (Map.Entry entry : licenseBindings.entrySet()) {
            IConfigurationElement[] elements;
            LicenseBinding binding = (LicenseBinding)entry.getKey();
            IExtension extension = (IExtension)entry.getValue();
            boolean useSpecifiedLicenseType = this.findByTagAndAttr(TAG_LICENSE, ATT_LICENSE_TYPE, licenseType, extension).length > 0;
            IConfigurationElement[] iConfigurationElementArray = elements = this.findByTagAndAttr(TAG_LICENSE, ATT_LICENSE_ID, binding.licenseId, extension);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                License license;
                IConfigurationElement element = iConfigurationElementArray[n2];
                if ((useSpecifiedLicenseType && licenseType.equals(element.getAttribute(ATT_LICENSE_TYPE)) || !useSpecifiedLicenseType && (element.getAttribute(ATT_LICENSE_TYPE) == null || element.getAttribute(ATT_LICENSE_TYPE).length() == 0)) && (license = this.createLicense(element)) != null) {
                    license.setLicenseLabel(binding.label != null ? binding.label : offeringOrFix.getName());
                    license.setGrouping(binding.grouping != null ? binding.grouping : offeringOrFix.getName());
                    license.setPrimary(binding.primary);
                    license.setSubGroups(binding.subGroups);
                    pageList.add(license);
                }
                ++n2;
            }
        }
        return pageList.toArray(new License[pageList.size()]);
    }

    private License createLicense(IConfigurationElement element) {
        String file = element.getAttribute(ATT_FILE);
        if (file == null) {
            return null;
        }
        String namespace = element.getContributor().getName();
        Bundle bundle = Platform.getBundle((String)namespace);
        if (bundle == null) {
            return null;
        }
        return new License(bundle, file);
    }

    @Override
    protected Comparable createBindingEntry(IConfigurationElement element) {
        String licenseId = element.getAttribute(ATT_LICENSE_ID);
        String label = element.getAttribute(ATT_LABEL);
        String grouping = element.getAttribute(ATT_GROUPING);
        boolean primary = Boolean.valueOf(element.getAttribute(ATT_PRIMARY));
        if (licenseId == null) {
            return null;
        }
        ArrayList subGroups = new ArrayList();
        IConfigurationElement[] childrenElements = element.getChildren();
        this.parseSubGroupElements(childrenElements, subGroups);
        return new LicenseBinding(licenseId, grouping, label, primary, subGroups);
    }

    private void parseSubGroupElements(IConfigurationElement[] elements, List subGroups) {
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(LICENSE_SUB_GROUP)) {
                subGroups.add(element.getAttribute(ATT_LABEL));
                this.parseSubGroupElements(element.getChildren(), subGroups);
            }
            ++n2;
        }
    }

    public static final class License {
        private String label;
        private String grouping;
        private final String fileName;
        private final Bundle bundle;
        private boolean primary;
        private List subGroups;
        private final Map localeLicenseMap = new HashMap();
        private final Map localeFileFullPath = new HashMap();

        License(Bundle bundle, String fileName) {
            this.bundle = bundle;
            this.fileName = fileName;
            this.primary = false;
        }

        void setPrimary(boolean primary) {
            this.primary = primary;
        }

        public boolean isPrimary() {
            return this.primary;
        }

        public String getLicenseText(Locale locale) throws IOException {
            String existingLicenseText = (String)this.localeLicenseMap.get(locale);
            if (existingLicenseText == null) {
                Map<String, String> overrideMap;
                Path path = new Path("$nl$/" + this.fileName);
                URL url = FileLocator.find((Bundle)this.bundle, (IPath)path, overrideMap = Collections.singletonMap("$nl$", locale.toString()));
                if (url == null) {
                    ComIbmCicCommonCorePlugin.log((IStatus)new Status(4, this.bundle.getSymbolicName(), 0, "Could not find " + this.fileName + " for locale " + locale.toString(), null));
                    existingLicenseText = "";
                } else {
                    String fullPath = (String)this.localeFileFullPath.get(locale);
                    if (fullPath == null) {
                        this.localeFileFullPath.put(locale, url.getFile());
                    }
                    try (BufferedReader reader = null;){
                        try {
                            PushbackInputStream in = this.processBOM(url.openStream());
                            reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
                            char[] buffer = new char[2048];
                            StringBuffer licenseText = new StringBuffer();
                            int length = 0;
                            while ((length = reader.read(buffer)) != -1) {
                                licenseText.append(buffer, 0, length);
                            }
                            existingLicenseText = licenseText.toString();
                        }
                        catch (IOException e) {
                            ComIbmCicCommonCorePlugin.logException(e);
                            throw e;
                        }
                    }
                }
            }
            this.localeLicenseMap.put(locale, existingLicenseText);
            return existingLicenseText;
        }

        private PushbackInputStream processBOM(InputStream in) throws IOException {
            int actuallyReadCount;
            int BOM_SIZE = 3;
            PushbackInputStream pushBackStream = new PushbackInputStream(in, 3);
            byte[] bomBuffer = new byte[3];
            int unreadCount = actuallyReadCount = pushBackStream.read(bomBuffer, 0, 3);
            if (bomBuffer[0] == -17 && bomBuffer[1] == -69 && bomBuffer[2] == -65) {
                unreadCount -= 3;
            }
            if (unreadCount > 0) {
                pushBackStream.unread(bomBuffer, actuallyReadCount - unreadCount, unreadCount);
            }
            return pushBackStream;
        }

        void setLicenseLabel(String label) {
            this.label = label;
        }

        public String getLicenseLabel() {
            return this.label;
        }

        public String toString() {
            return this.getLicenseLabel();
        }

        void setGrouping(String grouping) {
            this.grouping = grouping;
        }

        public String getGrouping() {
            return this.grouping;
        }

        void setSubGroups(List subGroups) {
            this.subGroups = subGroups;
        }

        public List getSubGroups() {
            return this.subGroups;
        }

        public String getFileFullPathName(Locale locale) {
            return (String)this.localeFileFullPath.get(locale);
        }
    }

    private static final class LicenseBinding
    implements Comparable {
        public final String licenseId;
        public final String grouping;
        public final String label;
        public final boolean primary;
        public final List subGroups;

        public LicenseBinding(String licenseId2, String grouping2, String label2, boolean primary, List subGroups) {
            this.licenseId = licenseId2;
            this.grouping = grouping2;
            this.label = label2;
            this.primary = primary;
            this.subGroups = subGroups;
        }

        public String toString() {
            return this.licenseId;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LicenseBinding) {
                LicenseBinding other = (LicenseBinding)obj;
                return other.licenseId.equals(this.licenseId);
            }
            return false;
        }

        public int hashCode() {
            return Util.hashCode((Object)this.licenseId);
        }

        public int compareTo(Object o) {
            if (o instanceof LicenseBinding) {
                LicenseBinding other = (LicenseBinding)o;
                return this.licenseId.compareTo(other.licenseId);
            }
            return -1;
        }
    }
}

